/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume.kafka;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategyConfiguration;
import org.apache.camel.processor.resume.kafka.SingleNodeKafkaResumeStrategy;
import org.apache.camel.resume.Deserializable;
import org.apache.camel.resume.Resumable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiNodeKafkaResumeStrategy<K extends Resumable>
extends SingleNodeKafkaResumeStrategy<K> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiNodeKafkaResumeStrategy.class);
    private final ExecutorService executorService;

    public MultiNodeKafkaResumeStrategy(KafkaResumeStrategyConfiguration resumeStrategyConfiguration) {
        this(resumeStrategyConfiguration, Executors.newSingleThreadExecutor());
    }

    public MultiNodeKafkaResumeStrategy(KafkaResumeStrategyConfiguration resumeStrategyConfiguration, ExecutorService executorService) {
        super(resumeStrategyConfiguration);
        this.executorService = executorService;
    }

    @Override
    protected void poll() {
        this.poll(this.getConsumer());
    }

    protected void poll(Consumer<byte[], byte[]> consumer) {
        ConsumerRecords<byte[], byte[]> records;
        Deserializable deserializable = (Deserializable)this.getAdapter();
        while (!(records = this.consume(10, consumer)).isEmpty()) {
            for (ConsumerRecord record : records) {
                byte[] value = (byte[])record.value();
                LOG.trace("Read from Kafka: {}", (Object)value);
                deserializable.deserialize(ByteBuffer.wrap((byte[])record.key()), ByteBuffer.wrap((byte[])record.value()));
            }
        }
    }

    @Override
    public void loadCache() throws Exception {
        super.loadCache();
        this.executorService.submit(() -> this.refresh());
    }

    private void refresh() {
        LOG.trace("Creating a offset cache refresher");
        try {
            Properties prop = (Properties)this.getResumeStrategyConfiguration().getConsumerProperties().clone();
            prop.setProperty("group.id", UUID.randomUUID().toString());
            try (KafkaConsumer consumer = new KafkaConsumer(prop);){
                consumer.subscribe(Collections.singletonList(this.getResumeStrategyConfiguration().getTopic()));
                this.poll((Consumer<byte[], byte[]>)consumer);
            }
        }
        catch (Exception e) {
            LOG.error("Error while refreshing the local cache: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.executorService.shutdown();
        }
        finally {
            super.stop();
        }
    }
}

