/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.services.kinesisfirehose.model.PutRecordRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordResult;
import com.amazonaws.services.kinesisfirehose.model.Record;
import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.firehose.KinesisFirehoseEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisFirehoseProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisFirehoseProducer.class);

    public KinesisFirehoseProducer(KinesisFirehoseEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KinesisFirehoseEndpoint getEndpoint() {
        return (KinesisFirehoseEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PutRecordRequest request = this.createRequest(exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PutRecordResult putRecordResult = this.getEndpoint().getClient().putRecord(request);
        LOG.trace("Received result [{}]", (Object)putRecordResult);
        Message message = KinesisFirehoseProducer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsKinesisFirehoseRecordId", (Object)putRecordResult.getRecordId());
    }

    private PutRecordRequest createRequest(Exchange exchange) {
        ByteBuffer body = (ByteBuffer)exchange.getIn().getBody(ByteBuffer.class);
        Record record = new Record();
        record.setData(body);
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setDeliveryStreamName(this.getEndpoint().getConfiguration().getStreamName());
        putRecordRequest.setRecord(record);
        return putRecordRequest;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

