/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.iam;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.iam.IAMConfiguration;
import org.apache.camel.component.aws.iam.IAMProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.23.0", scheme="aws-iam", title="AWS IAM", syntax="aws-iam:label", producerOnly=true, label="cloud,management")
public class IAMEndpoint
extends ScheduledPollEndpoint {
    private AmazonIdentityManagement iamClient;
    @UriParam
    private IAMConfiguration configuration;

    public IAMEndpoint(String uri, Component component, IAMConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new IAMProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.iamClient = this.configuration.getIamClient() != null ? this.configuration.getIamClient() : this.createIAMClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getIamClient()) && this.iamClient != null) {
            this.iamClient.shutdown();
        }
        super.doStop();
    }

    public IAMConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonIdentityManagement getIamClient() {
        return this.iamClient;
    }

    AmazonIdentityManagement createIAMClient() {
        AmazonIdentityManagement client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonIdentityManagementClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonIdentityManagementClientBuilder.standard() : (AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonIdentityManagementClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonIdentityManagement)clientBuilder.build();
        return client;
    }
}

