/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.iam;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.iam.IAMComponentVerifierExtension;
import org.apache.camel.component.aws.iam.IAMConfiguration;
import org.apache.camel.component.aws.iam.IAMEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-iam")
public class IAMComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private IAMConfiguration configuration;

    public IAMComponent() {
        this(null);
    }

    public IAMComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new IAMComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        IAMConfiguration configuration = this.configuration != null ? this.configuration.copy() : new IAMConfiguration();
        IAMEndpoint endpoint = new IAMEndpoint(uri, (Component)this, configuration);
        endpoint.getConfiguration().setAccessKey(this.accessKey);
        endpoint.getConfiguration().setSecretKey(this.secretKey);
        endpoint.getConfiguration().setRegion(this.region);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration);
        if (configuration.getIamClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon IAM client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public IAMConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IAMConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private void checkAndSetRegistryClient(IAMConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonIdentityManagement.class);
        if (clients.size() == 1) {
            configuration.setIamClient((AmazonIdentityManagement)clients.stream().findFirst().get());
        }
    }
}

