/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainListener;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainSupport
extends BaseMainSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(MainSupport.class);
    protected static final int UNINITIALIZED_EXIT_CODE = Integer.MIN_VALUE;
    protected static final int DEFAULT_EXIT_CODE = 0;
    protected final AtomicInteger exitCode = new AtomicInteger(Integer.MIN_VALUE);
    protected final CountDownLatch latch = new CountDownLatch(1);

    protected MainSupport(Class ... configurationClasses) {
        this();
        this.addConfigurationClass(configurationClasses);
    }

    protected MainSupport() {
    }

    public void run() throws Exception {
        if (!this.completed.get()) {
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.internalBeforeStop();
                this.beforeStop();
                this.stop();
                this.afterStop();
            }
            catch (Exception e) {
                LOG.error("Failed: {}", (Object)e, (Object)e);
            }
        }
    }

    public void disableHangupSupport() {
        this.mainConfigurationProperties.setHangupInterceptorEnabled(false);
    }

    public void enableHangupSupport() {
        this.mainConfigurationProperties.setHangupInterceptorEnabled(true);
    }

    protected void beforeStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStart(this);
        }
    }

    protected void afterStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    private void internalBeforeStart() {
        if (this.mainConfigurationProperties.isHangupInterceptorEnabled()) {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor");
            HangupInterceptor task = new HangupInterceptor(this);
            task.setName(threadName);
            Runtime.getRuntime().addShutdownHook(task);
        }
    }

    protected void beforeStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStop(this);
        }
    }

    protected void afterStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    private void internalBeforeStop() {
        try {
            if (this.camelTemplate != null) {
                ServiceHelper.stopService((Object)this.camelTemplate);
                this.camelTemplate = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    public void completed() {
        this.completed.set(true);
        this.exitCode.compareAndSet(Integer.MIN_VALUE, 0);
        this.latch.countDown();
    }

    @Deprecated
    public int getDuration() {
        return this.mainConfigurationProperties.getDurationMaxSeconds();
    }

    @Deprecated
    public void setDuration(int duration) {
        this.mainConfigurationProperties.setDurationMaxSeconds(duration);
    }

    @Deprecated
    public int getDurationIdle() {
        return this.mainConfigurationProperties.getDurationMaxIdleSeconds();
    }

    @Deprecated
    public void setDurationIdle(int durationIdle) {
        this.mainConfigurationProperties.setDurationMaxIdleSeconds(durationIdle);
    }

    @Deprecated
    public int getDurationMaxMessages() {
        return this.mainConfigurationProperties.getDurationMaxMessages();
    }

    @Deprecated
    public void setDurationMaxMessages(int durationMaxMessages) {
        this.mainConfigurationProperties.setDurationMaxMessages(durationMaxMessages);
    }

    @Deprecated
    public void setDurationHitExitCode(int durationHitExitCode) {
        this.mainConfigurationProperties.setDurationHitExitCode(durationHitExitCode);
    }

    @Deprecated
    public int getDurationHitExitCode() {
        return this.mainConfigurationProperties.getDurationHitExitCode();
    }

    public int getExitCode() {
        return this.exitCode.get();
    }

    public boolean isTrace() {
        return this.mainConfigurationProperties.isTracing();
    }

    public void enableTrace() {
        this.mainConfigurationProperties.setTracing(true);
    }

    protected void doStop() throws Exception {
        this.completed();
    }

    protected void doStart() throws Exception {
    }

    @Override
    protected void configureLifecycle(CamelContext camelContext) throws Exception {
        if (this.mainConfigurationProperties.getDurationMaxMessages() > 0 || this.mainConfigurationProperties.getDurationMaxIdleSeconds() > 0) {
            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.mainConfigurationProperties.getDurationMaxMessages(), this.mainConfigurationProperties.getDurationMaxIdleSeconds(), this.completed, this.latch, true);
            ServiceHelper.startService((Object)((Object)notifier));
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainLifecycleStrategy(this.completed, this.latch));
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                int idle = this.mainConfigurationProperties.getDurationMaxIdleSeconds();
                int max = this.mainConfigurationProperties.getDurationMaxMessages();
                long sec = this.mainConfigurationProperties.getDurationMaxSeconds();
                if (sec > 0L) {
                    LOG.info("Waiting for: {} seconds", (Object)sec);
                    this.latch.await(sec, TimeUnit.SECONDS);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.completed.set(true);
                    continue;
                }
                if (idle > 0 || max > 0) {
                    if (idle > 0 && max > 0) {
                        LOG.info("Waiting to be idle for: {} seconds or until: {} messages has been processed", (Object)idle, (Object)max);
                    } else if (idle > 0) {
                        LOG.info("Waiting to be idle for: {} seconds", (Object)idle);
                    } else {
                        LOG.info("Waiting until: {} messages has been processed", (Object)max);
                    }
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.mainConfigurationProperties.getDurationHitExitCode());
                    this.latch.await();
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.completed.set(true);
                this.latch.countDown();
                Thread.currentThread().interrupt();
            }
        }
    }

    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }

    private static final class HangupInterceptor
    extends Thread {
        Logger log = LoggerFactory.getLogger(this.getClass());
        final MainSupport mainInstance;

        HangupInterceptor(MainSupport main) {
            this.mainInstance = main;
        }

        @Override
        public void run() {
            this.log.info("Received hang up - stopping the main instance.");
            try {
                this.mainInstance.stop();
            }
            catch (Exception ex) {
                this.log.warn("Error during stopping the main instance.", (Throwable)ex);
            }
        }
    }
}

