/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Locale;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="log")
public class LogComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(LogComponent.class);
    @Metadata(label="advanced")
    private ExchangeFormatter exchangeFormatter;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ExchangeFormatter logFormatter;
        LoggingLevel level = this.getLoggingLevel(parameters);
        Logger providedLogger = this.getLogger(parameters);
        if (providedLogger == null) {
            Map availableLoggers = this.getCamelContext().getRegistry().findByTypeWithName(Logger.class);
            if (availableLoggers.size() == 1) {
                providedLogger = (Logger)availableLoggers.values().iterator().next();
                LOG.info("Using custom Logger: {}", (Object)providedLogger);
            } else if (availableLoggers.size() > 1) {
                LOG.info("More than one {} instance found in the registry. Falling back to creating logger from URI {}.", (Object)Logger.class.getName(), (Object)uri);
            }
        }
        if ((logFormatter = (ExchangeFormatter)this.getCamelContext().getRegistry().lookupByNameAndType("logFormatter", ExchangeFormatter.class)) != null) {
            this.setProperties(logFormatter, parameters);
        } else if (this.exchangeFormatter != null) {
            logFormatter = this.exchangeFormatter;
        }
        LogEndpoint endpoint = new LogEndpoint(uri, (Component)this);
        endpoint.setLevel(level.name());
        endpoint.setExchangeFormatter(logFormatter);
        if (providedLogger == null) {
            endpoint.setLoggerName(remaining);
        } else {
            endpoint.setProvidedLogger(providedLogger);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = (String)this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf((String)levelText.toUpperCase(Locale.ENGLISH));
    }

    protected Logger getLogger(Map<String, Object> parameters) {
        return (Logger)this.getAndRemoveOrResolveReferenceParameter(parameters, "logger", Logger.class);
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }
}

