/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.AmazonECSClientBuilder;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ecs.ECSConfiguration;
import org.apache.camel.component.aws.ecs.ECSProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.0.0", scheme="aws-ecs", title="AWS Elastic Container Service (ECS)", syntax="aws-ecs:label", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class ECSEndpoint
extends ScheduledPollEndpoint {
    private AmazonECS ecsClient;
    @UriParam
    private ECSConfiguration configuration;

    public ECSEndpoint(String uri, Component component, ECSConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new ECSProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.ecsClient = this.configuration.getEcsClient() != null ? this.configuration.getEcsClient() : this.createECSClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getEcsClient()) && this.ecsClient != null) {
            this.ecsClient.shutdown();
        }
        super.doStop();
    }

    public ECSConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonECS getEcsClient() {
        return this.ecsClient;
    }

    AmazonECS createECSClient() {
        AmazonECS client = null;
        ClientConfiguration clientConfiguration = null;
        AmazonECSClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AmazonECSClientBuilder)((AmazonECSClientBuilder)AmazonECSClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AmazonECSClientBuilder)AmazonECSClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AmazonECSClientBuilder.standard() : (AmazonECSClientBuilder)AmazonECSClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AmazonECSClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AmazonECS)clientBuilder.build();
        return client;
    }
}

