/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.ec2.EC2ComponentVerifierExtension;
import org.apache.camel.component.aws.ec2.EC2Configuration;
import org.apache.camel.component.aws.ec2.EC2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-ec2")
public class EC2Component
extends DefaultComponent {
    @Metadata
    private EC2Configuration configuration = new EC2Configuration();

    public EC2Component() {
        this(null);
    }

    public EC2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new EC2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EC2Configuration configuration = this.configuration != null ? this.configuration.copy() : new EC2Configuration();
        EC2Endpoint endpoint = new EC2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getAmazonEc2Client() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("amazonEC2Client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public EC2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EC2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(EC2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonEC2.class);
        if (clients.size() == 1) {
            configuration.setAmazonEc2Client((AmazonEC2)clients.stream().findFirst().get());
        }
    }
}

