/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class QueryCommand
extends AbstractDdbCommand {
    public QueryCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        QueryRequest query = new QueryRequest().withTableName(this.determineTableName()).withAttributesToGet(this.determineAttributeNames()).withConsistentRead(this.determineConsistentRead()).withExclusiveStartKey(this.determineStartKey()).withKeyConditions(this.determineKeyConditions()).withExclusiveStartKey(this.determineStartKey()).withLimit(this.determineLimit()).withScanIndexForward(this.determineScanIndexForward());
        if (this.exchange.getIn().getHeader("CamelAwsDdbIndexName", String.class) != null) {
            query.withIndexName((String)this.exchange.getIn().getHeader("CamelAwsDdbIndexName", String.class));
        }
        QueryResult result = this.ddbClient.query(query);
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("CamelAwsDdbItems", result.getItems());
        tmp.put("CamelAwsDdbLastEvaluatedKey", result.getLastEvaluatedKey());
        tmp.put("CamelAwsDdbConsumedCapacity", result.getConsumedCapacity());
        tmp.put("CamelAwsDdbCount", result.getCount());
        this.addToResults(tmp);
    }

    private Map<String, AttributeValue> determineStartKey() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbStartKey", Map.class);
    }

    private Boolean determineScanIndexForward() {
        return (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbScanIndexForward", Boolean.class);
    }

    private Map determineKeyConditions() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbKeyConditions", Map.class);
    }
}

