/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.transform.aws.ddb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

public class JsonToDdbModelConverter {
    public String process(@ExchangeProperty(value="operation") String operation, Exchange exchange) throws InvalidPayloadException {
        if (exchange.getMessage().getHeaders().containsKey("CamelAwsDdbItem") || exchange.getMessage().getHeaders().containsKey("CamelAwsDdbKey")) {
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonBody = (JsonNode)exchange.getMessage().getMandatoryBody(JsonNode.class);
        JsonNode key = jsonBody.get("key");
        JsonNode item = jsonBody.get("item");
        Map keyProps = key != null ? (Map)mapper.convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){}) : (Map)mapper.convertValue((Object)jsonBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map itemProps = item != null ? (Map)mapper.convertValue((Object)item, (TypeReference)new TypeReference<Map<String, Object>>(){}) : keyProps;
        Map<String, AttributeValue> keyMap = this.getAttributeValueMap(keyProps);
        switch (Ddb2Operations.valueOf((String)operation)) {
            case PutItem: {
                exchange.getMessage().setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.PutItem);
                exchange.getMessage().setHeader("CamelAwsDdbItem", this.getAttributeValueMap(itemProps));
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_OLD.toString(), exchange);
                break;
            }
            case UpdateItem: {
                exchange.getMessage().setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.UpdateItem);
                exchange.getMessage().setHeader("CamelAwsDdbKey", keyMap);
                exchange.getMessage().setHeader("CamelAwsDdbUpdateValues", this.getAttributeValueUpdateMap(itemProps));
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_NEW.toString(), exchange);
                break;
            }
            case DeleteItem: {
                exchange.getMessage().setHeader("CamelAwsDdbOperation", (Object)Ddb2Operations.DeleteItem);
                exchange.getMessage().setHeader("CamelAwsDdbKey", keyMap);
                this.setHeaderIfNotPresent("CamelAwsDdbReturnValues", ReturnValue.ALL_OLD.toString(), exchange);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported operation '%s'", operation));
            }
        }
        return "";
    }

    private void setHeaderIfNotPresent(String headerName, Object value, Exchange exchange) {
        exchange.getMessage().setHeader(headerName, value);
    }

    private Map<String, AttributeValue> getAttributeValueMap(Map<String, Object> body) {
        LinkedHashMap<String, AttributeValue> attributeValueMap = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> attribute : body.entrySet()) {
            attributeValueMap.put(attribute.getKey(), JsonToDdbModelConverter.getAttributeValue(attribute.getValue()));
        }
        return attributeValueMap;
    }

    private Map<String, AttributeValueUpdate> getAttributeValueUpdateMap(Map<String, Object> body) {
        LinkedHashMap<String, AttributeValueUpdate> attributeValueMap = new LinkedHashMap<String, AttributeValueUpdate>();
        for (Map.Entry<String, Object> attribute : body.entrySet()) {
            attributeValueMap.put(attribute.getKey(), JsonToDdbModelConverter.getAttributeValueUpdate(attribute.getValue()));
        }
        return attributeValueMap;
    }

    private static AttributeValue getAttributeValue(Object value) {
        if (value == null) {
            return (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        }
        if (value instanceof String) {
            return (AttributeValue)AttributeValue.builder().s(value.toString()).build();
        }
        if (value instanceof Integer) {
            return (AttributeValue)AttributeValue.builder().n(value.toString()).build();
        }
        if (value instanceof Boolean) {
            return (AttributeValue)AttributeValue.builder().bool((Boolean)value).build();
        }
        if (value instanceof String[]) {
            return (AttributeValue)AttributeValue.builder().ss((String[])value).build();
        }
        if (value instanceof int[]) {
            return (AttributeValue)AttributeValue.builder().ns((Collection)Stream.of((int[])value).map(Object::toString).collect(Collectors.toList())).build();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.isEmpty()) {
                return (AttributeValue)AttributeValue.builder().ss(new String[0]).build();
            }
            if (values.get(0) instanceof Integer) {
                return (AttributeValue)AttributeValue.builder().ns((Collection)values.stream().map(Object::toString).collect(Collectors.toList())).build();
            }
            return (AttributeValue)AttributeValue.builder().ss((Collection)values.stream().map(Object::toString).collect(Collectors.toList())).build();
        }
        if (value instanceof Map) {
            LinkedHashMap<String, AttributeValue> nestedAttributes = new LinkedHashMap<String, AttributeValue>();
            for (Map.Entry nested : ((Map)value).entrySet()) {
                nestedAttributes.put(nested.getKey().toString(), JsonToDdbModelConverter.getAttributeValue(nested.getValue()));
            }
            return (AttributeValue)AttributeValue.builder().m(nestedAttributes).build();
        }
        return (AttributeValue)AttributeValue.builder().s(value.toString()).build();
    }

    private static AttributeValueUpdate getAttributeValueUpdate(Object value) {
        return (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value(JsonToDdbModelConverter.getAttributeValue(value)).build();
    }
}

