/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.Shard;

@SdkInternalApi
public class ShardMarshaller {
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").build();
    private static final MarshallingInfo<StructuredPojo> SEQUENCENUMBERRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumberRange").build();
    private static final MarshallingInfo<String> PARENTSHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentShardId").build();
    private static final ShardMarshaller instance = new ShardMarshaller();

    public static ShardMarshaller getInstance() {
        return instance;
    }

    public void marshall(Shard shard, ProtocolMarshaller protocolMarshaller) {
        if (shard == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)shard.getShardId(), SHARDID_BINDING);
            protocolMarshaller.marshall((Object)shard.getSequenceNumberRange(), SEQUENCENUMBERRANGE_BINDING);
            protocolMarshaller.marshall((Object)shard.getParentShardId(), PARENTSHARDID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

