/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream;

import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponent;
import org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration;
import org.apache.camel.component.aws.ddbstream.SequenceNumberProvider;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class DdbStreamComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private DdbStreamConfiguration getOrCreateConfiguration(DdbStreamComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new DdbStreamConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DdbStreamComponent target = (DdbStreamComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazondynamodbstreamsclient": 
            case "amazonDynamoDbStreamsClient": {
                this.getOrCreateConfiguration(target).setAmazonDynamoDbStreamsClient((AmazonDynamoDBStreams)DdbStreamComponentConfigurer.property((CamelContext)camelContext, AmazonDynamoDBStreams.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((DdbStreamConfiguration)DdbStreamComponentConfigurer.property((CamelContext)camelContext, DdbStreamConfiguration.class, (Object)value));
                return true;
            }
            case "iteratortype": 
            case "iteratorType": {
                this.getOrCreateConfiguration(target).setIteratorType((ShardIteratorType)DdbStreamComponentConfigurer.property((CamelContext)camelContext, ShardIteratorType.class, (Object)value));
                return true;
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                this.getOrCreateConfiguration(target).setMaxResultsPerRequest((Integer)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)DdbStreamComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)DdbStreamComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sequencenumberprovider": 
            case "sequenceNumberProvider": {
                this.getOrCreateConfiguration(target).setSequenceNumberProvider((SequenceNumberProvider)DdbStreamComponentConfigurer.property((CamelContext)camelContext, SequenceNumberProvider.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DdbStreamComponent target = (DdbStreamComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazondynamodbstreamsclient": 
            case "amazonDynamoDbStreamsClient": {
                return this.getOrCreateConfiguration(target).getAmazonDynamoDbStreamsClient();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "iteratortype": 
            case "iteratorType": {
                return this.getOrCreateConfiguration(target).getIteratorType();
            }
            case "maxresultsperrequest": 
            case "maxResultsPerRequest": {
                return this.getOrCreateConfiguration(target).getMaxResultsPerRequest();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "sequencenumberprovider": 
            case "sequenceNumberProvider": {
                return this.getOrCreateConfiguration(target).getSequenceNumberProvider();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("amazonDynamoDbStreamsClient", AmazonDynamoDBStreams.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("configuration", DdbStreamConfiguration.class);
        map.put("iteratorType", ShardIteratorType.class);
        map.put("maxResultsPerRequest", Integer.TYPE);
        map.put("proxyHost", String.class);
        map.put("proxyPort", Integer.class);
        map.put("proxyProtocol", Protocol.class);
        map.put("region", String.class);
        map.put("sequenceNumberProvider", SequenceNumberProvider.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("accessKey", String.class);
        map.put("secretKey", String.class);
        ALL_OPTIONS = map;
    }
}

