/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public abstract class AbstractDdbCommand {
    protected DdbConfiguration configuration;
    protected Exchange exchange;
    protected AmazonDynamoDB ddbClient;

    public AbstractDdbCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        this.ddbClient = ddbClient;
        this.configuration = configuration;
        this.exchange = exchange;
    }

    public abstract void execute();

    protected Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected String determineTableName() {
        String tableName = (String)this.exchange.getIn().getHeader("CamelAwsDdbTableName", String.class);
        return tableName != null ? tableName : this.configuration.getTableName();
    }

    protected Map<String, ExpectedAttributeValue> determineUpdateCondition() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbUpdateCondition", Map.class);
    }

    protected Map<String, AttributeValue> determineItem() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbItem", Map.class);
    }

    protected String determineReturnValues() {
        return (String)this.exchange.getIn().getHeader("CamelAwsDdbReturnValues", String.class);
    }

    protected void addAttributesToResult(Map<String, AttributeValue> attributes) {
        Message msg = this.getMessageForResponse(this.exchange);
        msg.setHeader("CamelAwsDdbAttributes", attributes);
    }

    protected void addToResults(Map<String, Object> map) {
        Message msg = this.getMessageForResponse(this.exchange);
        for (Map.Entry<String, Object> en : map.entrySet()) {
            msg.setHeader(en.getKey(), en.getValue());
        }
    }

    protected Map<String, AttributeValue> determineKey() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbKey", Map.class);
    }

    protected Collection<String> determineAttributeNames() {
        return (Collection)this.exchange.getIn().getHeader("CamelAwsDdbAttributeNames", Collection.class);
    }

    protected Boolean determineConsistentRead() {
        return (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbConsistentRead", (Object)this.configuration.isConsistentRead(), Boolean.class);
    }

    protected Map<String, AttributeValue> determineExclusiveStartKey() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbStartKey", Map.class);
    }

    protected Integer determineLimit() {
        return (Integer)this.exchange.getIn().getHeader("CamelAwsDdbLimit", Integer.class);
    }
}

