/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.Protocol;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import java.util.Date;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.cw.CwComponent;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class CwComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private CwConfiguration getOrCreateConfiguration(CwComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new CwConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CwComponent target = (CwComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)CwComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                this.getOrCreateConfiguration(target).setAmazonCwClient((AmazonCloudWatch)CwComponentConfigurer.property((CamelContext)camelContext, AmazonCloudWatch.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)CwComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)CwComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((CwConfiguration)CwComponentConfigurer.property((CamelContext)camelContext, CwConfiguration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)CwComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "name": {
                this.getOrCreateConfiguration(target).setName((String)CwComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)CwComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)CwComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)CwComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)CwComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)CwComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "timestamp": {
                this.getOrCreateConfiguration(target).setTimestamp((Date)CwComponentConfigurer.property((CamelContext)camelContext, Date.class, (Object)value));
                return true;
            }
            case "unit": {
                this.getOrCreateConfiguration(target).setUnit((String)CwComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "value": {
                this.getOrCreateConfiguration(target).setValue((Double)CwComponentConfigurer.property((CamelContext)camelContext, Double.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CwComponent target = (CwComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazoncwclient": 
            case "amazonCwClient": {
                return this.getOrCreateConfiguration(target).getAmazonCwClient();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "name": {
                return this.getOrCreateConfiguration(target).getName();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "timestamp": {
                return this.getOrCreateConfiguration(target).getTimestamp();
            }
            case "unit": {
                return this.getOrCreateConfiguration(target).getUnit();
            }
            case "value": {
                return this.getOrCreateConfiguration(target).getValue();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("amazonCwClient", AmazonCloudWatch.class);
        map.put("autoDiscoverClient", Boolean.TYPE);
        map.put("configuration", CwConfiguration.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("name", String.class);
        map.put("proxyHost", String.class);
        map.put("proxyPort", Integer.class);
        map.put("proxyProtocol", Protocol.class);
        map.put("region", String.class);
        map.put("timestamp", Date.class);
        map.put("unit", String.class);
        map.put("value", Double.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("accessKey", String.class);
        map.put("secretKey", String.class);
        ALL_OPTIONS = map;
    }
}

