/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.cw.CwComponentVerifierExtension;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.component.aws.cw.CwEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="aws-cw")
public class CwComponent
extends DefaultComponent {
    @Metadata
    private CwConfiguration configuration = new CwConfiguration();

    public CwComponent() {
        this(null);
    }

    public CwComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new CwComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Metric namespace must be specified.");
        }
        CwConfiguration configuration = this.configuration != null ? this.configuration.copy() : new CwConfiguration();
        configuration.setNamespace(remaining);
        CwEndpoint endpoint = new CwEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getAmazonCwClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonCwClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public CwConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CwConfiguration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(CwConfiguration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(AmazonCloudWatch.class);
        if (clients.size() == 1) {
            configuration.setAmazonCwClient((AmazonCloudWatch)clients.stream().findFirst().get());
        }
    }
}

