/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.copycat.client.session.ClientSessionState;
import io.atomix.copycat.protocol.OperationResponse;
import io.atomix.copycat.protocol.PublishRequest;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientSequencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientSequencer.class);
    private final ClientSessionState state;
    long requestSequence;
    long responseSequence;
    long eventIndex;
    private final Queue<EventCallback> eventCallbacks = new ArrayDeque<EventCallback>();
    private final Map<Long, ResponseCallback> responseCallbacks = new HashMap<Long, ResponseCallback>();

    ClientSequencer(ClientSessionState state) {
        this.state = state;
    }

    public long nextRequest() {
        return ++this.requestSequence;
    }

    public void sequenceEvent(PublishRequest request, Runnable callback) {
        if (this.requestSequence == this.responseSequence) {
            LOGGER.trace("{} - Completing {}", (Object)this.state.getSessionId(), (Object)request);
            callback.run();
            this.eventIndex = request.eventIndex();
        } else {
            this.eventCallbacks.add(new EventCallback(request, callback));
            this.completeResponses();
        }
    }

    public void sequenceResponse(long sequence, OperationResponse response, Runnable callback) {
        if (sequence == this.responseSequence + 1L) {
            if (this.completeResponse(response, callback)) {
                ++this.responseSequence;
                this.completeResponses();
            } else {
                this.responseCallbacks.put(sequence, new ResponseCallback(response, callback));
            }
        } else {
            this.responseCallbacks.put(sequence, new ResponseCallback(response, callback));
        }
    }

    private void completeResponses() {
        ResponseCallback response = this.responseCallbacks.get(this.responseSequence + 1L);
        while (response != null && this.completeResponse(response.response, response.callback)) {
            this.responseCallbacks.remove(++this.responseSequence);
            response = this.responseCallbacks.get(this.responseSequence + 1L);
        }
        if (this.requestSequence == this.responseSequence) {
            EventCallback eventCallback = this.eventCallbacks.poll();
            while (eventCallback != null) {
                LOGGER.trace("{} - Completing {}", (Object)this.state.getSessionId(), (Object)eventCallback.request);
                eventCallback.run();
                this.eventIndex = eventCallback.request.eventIndex();
                eventCallback = this.eventCallbacks.poll();
            }
        }
    }

    private boolean completeResponse(OperationResponse response, Runnable callback) {
        if (response == null) {
            LOGGER.trace("{} - Completing failed request", (Object)this.state.getSessionId());
            callback.run();
            return true;
        }
        long responseEventIndex = response.eventIndex();
        if (responseEventIndex > this.eventIndex) {
            EventCallback eventCallback = this.eventCallbacks.peek();
            while (eventCallback != null && eventCallback.request.eventIndex() <= responseEventIndex) {
                this.eventCallbacks.remove();
                LOGGER.trace("{} - Completing {}", (Object)this.state.getSessionId(), (Object)eventCallback.request);
                eventCallback.run();
                this.eventIndex = eventCallback.request.eventIndex();
                eventCallback = this.eventCallbacks.peek();
            }
            if (responseEventIndex > this.eventIndex) {
                for (EventCallback event : this.eventCallbacks) {
                    if (event.request.previousIndex() > this.eventIndex || event.request.eventIndex() < response.eventIndex()) continue;
                    responseEventIndex = event.request.previousIndex();
                    break;
                }
            }
        }
        if (responseEventIndex <= this.eventIndex || this.eventIndex == 0L && responseEventIndex == this.state.getSessionId()) {
            LOGGER.trace("{} - Completing {}", (Object)this.state.getSessionId(), (Object)response);
            callback.run();
            return true;
        }
        return false;
    }

    private static final class EventCallback
    implements Runnable {
        private final PublishRequest request;
        private final Runnable callback;

        private EventCallback(PublishRequest request, Runnable callback) {
            this.request = request;
            this.callback = callback;
        }

        @Override
        public void run() {
            this.callback.run();
        }
    }

    private static final class ResponseCallback
    implements Runnable {
        private final OperationResponse response;
        private final Runnable callback;

        private ResponseCallback(OperationResponse response, Runnable callback) {
            this.response = response;
            this.callback = callback;
        }

        @Override
        public void run() {
            this.callback.run();
        }
    }
}

