/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.protocol.ConfigurationRequest;
import java.util.Objects;

public class ReconfigureRequest
extends ConfigurationRequest {
    private long index;
    private long term;

    public static Builder builder() {
        return new Builder(new ReconfigureRequest());
    }

    public static Builder builder(ReconfigureRequest request) {
        return new Builder(request);
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.index).writeLong(this.term);
        super.writeObject(buffer, serializer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.index = buffer.readLong();
        this.term = buffer.readLong();
        super.readObject(buffer, serializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.index, this.member);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ReconfigureRequest) {
            ReconfigureRequest request = (ReconfigureRequest)((Object)object);
            return request.index == this.index && request.term == this.term && request.member.equals(this.member);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, member=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.index, this.term, this.member);
    }

    public static class Builder
    extends ConfigurationRequest.Builder<Builder, ReconfigureRequest> {
        public Builder(ReconfigureRequest request) {
            super(request);
        }

        public Builder withIndex(long index) {
            ((ReconfigureRequest)this.request).index = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"index must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withTerm(long term) {
            ((ReconfigureRequest)this.request).term = (Long)Assert.argNot((Object)term, (term < 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            return this;
        }
    }
}

