/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.value;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.resource.Resource;
import io.atomix.variables.AbstractDistributedValue;
import io.atomix.variables.DistributedValue;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientConsumer;
import org.apache.camel.component.atomix.client.value.AtomixValueEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixValueConsumer
extends AbstractAtomixClientConsumer<AtomixValueEndpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomixValueConsumer.class);
    private final List<Listener<AbstractDistributedValue.ChangeEvent<Object>>> listeners = new ArrayList<Listener<AbstractDistributedValue.ChangeEvent<Object>>>();
    private final String resourceName;
    private final String resultHeader;
    private DistributedValue<Object> value;

    public AtomixValueConsumer(AtomixValueEndpoint endpoint, Processor processor, String resourceName) {
        super(endpoint, processor);
        this.resourceName = resourceName;
        this.resultHeader = endpoint.getConfiguration().getResultHeader();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.value = (DistributedValue)((AtomixValueEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getValue(this.resourceName, new Resource.Config(((AtomixValueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(this.resourceName)), new Resource.Options(((AtomixValueEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(this.resourceName))).join();
        LOG.debug("Subscribe to events for value: {}", (Object)this.resourceName);
        this.listeners.add((Listener<AbstractDistributedValue.ChangeEvent<Object>>)this.value.onChange(this::onEvent).join());
    }

    protected void doStop() throws Exception {
        this.listeners.forEach(Listener::close);
        super.doStop();
    }

    private void onEvent(AbstractDistributedValue.ChangeEvent<Object> event) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("CamelAtomixEventType", (Object)event.type());
        exchange.getIn().setHeader("CamelAtomixResourceOldValue", event.oldValue());
        if (this.resultHeader == null) {
            exchange.getIn().setBody(event.newValue());
        } else {
            exchange.getIn().setHeader(this.resultHeader, event.newValue());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }
}

