/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.set;

import io.atomix.collections.DistributedSet;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import java.time.Duration;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.set.AtomixSetConfiguration;
import org.apache.camel.component.atomix.client.set.AtomixSetEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;

public final class AtomixSetProducer
extends AbstractAtomixClientProducer<AtomixSetEndpoint, DistributedSet> {
    private final AtomixSetConfiguration configuration;

    protected AtomixSetProducer(AtomixSetEndpoint endpoint) {
        super(endpoint);
        this.configuration = endpoint.getConfiguration();
    }

    private long getResourceTtl(Message message) {
        Duration ttl = (Duration)message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Duration.class);
        return ttl != null ? ttl.toMillis() : 0L;
    }

    @InvokeOnHeader(value="ADD")
    boolean onAdd(Message message, AsyncCallback callback) throws Exception {
        DistributedSet set = (DistributedSet)this.getResource(message);
        long ttl = this.getResourceTtl(message);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            set.add(val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            set.add(val).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="CLEAR")
    boolean onClear(Message message, AsyncCallback callback) throws Exception {
        DistributedSet set = (DistributedSet)this.getResource(message);
        set.clear().thenAccept(result -> this.processResult(message, callback, result));
        return false;
    }

    @InvokeOnHeader(value="CONTAINS")
    boolean onContains(Message message, AsyncCallback callback) throws Exception {
        DistributedSet set = (DistributedSet)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        if (consistency != null) {
            set.contains(value, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            set.contains(value).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="IS_EMPTY")
    boolean onIsEmpty(Message message, AsyncCallback callback) throws Exception {
        DistributedSet set = (DistributedSet)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            set.isEmpty(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            set.isEmpty().thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="REMOVE")
    boolean onRemove(Message message, AsyncCallback callback) throws Exception {
        DistributedSet set = (DistributedSet)this.getResource(message);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        set.remove(value).thenAccept(result -> this.processResult(message, callback, result));
        return false;
    }

    @InvokeOnHeader(value="SIZE")
    boolean onSize(Message message, AsyncCallback callback) throws Exception {
        DistributedSet set = (DistributedSet)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            set.size(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            set.size().thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @Override
    protected String getProcessorKey(Message message) {
        return (String)message.getHeader("CamelAtomixResourceAction", this.configuration::getDefaultAction, String.class);
    }

    @Override
    protected String getResourceName(Message message) {
        return (String)message.getHeader("CamelAtomixResourceName", ((AtomixSetEndpoint)((Object)this.getAtomixEndpoint()))::getResourceName, String.class);
    }

    @Override
    protected DistributedSet<Object> createResource(String resourceName) {
        return (DistributedSet)((AtomixSetEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getSet(resourceName, new Resource.Config(((AtomixSetEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(resourceName)), new Resource.Options(((AtomixSetEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

