/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.concurrent.BlockingFuture;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.messaging.MessageFailedException;
import io.atomix.group.messaging.MessageProducer;
import io.atomix.group.messaging.internal.AbstractMessageClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMessageProducer<T>
implements MessageProducer<T> {
    private final int id;
    private final String name;
    private final MessageProducer.Delivery delivery;
    private final MessageProducer.Execution execution;
    private final AbstractMessageClient client;
    private long messageId;
    private final Map<Long, CompletableFuture> messageFutures = new ConcurrentHashMap<Long, CompletableFuture>();

    protected AbstractMessageProducer(String name, MessageProducer.Options options, AbstractMessageClient client) {
        this.name = name;
        this.delivery = options.getDelivery();
        this.execution = options.getExecution();
        this.client = client;
        this.id = client.producerService().registry().register(this);
    }

    String name() {
        return this.name;
    }

    void onAck(GroupCommands.Ack ack) {
        CompletableFuture messageFuture = this.messageFutures.remove(this.messageId);
        if (messageFuture != null) {
            if (this.execution == MessageProducer.Execution.SYNC) {
                if (ack.succeeded()) {
                    messageFuture.complete(null);
                } else {
                    messageFuture.completeExceptionally((Throwable)((Object)new MessageFailedException("message failed")));
                }
            } else if (this.execution == MessageProducer.Execution.REQUEST_REPLY) {
                if (ack.succeeded()) {
                    messageFuture.complete(ack.message());
                } else {
                    messageFuture.completeExceptionally((Throwable)((Object)new MessageFailedException("message failed")));
                }
            }
        }
    }

    protected <U> CompletableFuture<U> send(String member, T message) {
        if (this.execution == MessageProducer.Execution.ASYNC) {
            return this.sendAsync(member, message);
        }
        return this.sendSync(member, message);
    }

    private CompletableFuture sendSync(String member, T message) {
        BlockingFuture future = new BlockingFuture();
        long messageId = ++this.messageId;
        this.messageFutures.put(messageId, (CompletableFuture)future);
        this.client.producerService().send(new GroupCommands.Message(member, this.id, this.name, messageId, message, this.delivery, this.execution)).whenComplete((result, error) -> {
            CompletableFuture messageFuture;
            if (error != null && (messageFuture = this.messageFutures.remove(messageId)) != null) {
                messageFuture.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    private CompletableFuture sendAsync(String member, T message) {
        return this.client.producerService().send(new GroupCommands.Message(member, this.id, this.name, ++this.messageId, message, this.delivery, this.execution));
    }

    @Override
    public void close() {
        this.client.producerService().registry().close(this.id);
    }
}

