/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.copycat.server.storage.snapshot.FileSnapshot;
import io.atomix.copycat.server.storage.snapshot.MemorySnapshot;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotDescriptor;
import io.atomix.copycat.server.storage.snapshot.SnapshotFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStore
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotStore.class);
    private final String name;
    final Storage storage;
    private final Serializer serializer;
    private final TreeMap<Long, Snapshot> snapshots = new TreeMap();
    private Snapshot currentSnapshot;

    public SnapshotStore(String name, Storage storage, Serializer serializer) {
        this.name = (String)Assert.notNull((Object)name, (String)"name");
        this.storage = (Storage)Assert.notNull((Object)storage, (String)"storage");
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
        this.open();
    }

    private void open() {
        for (Snapshot snapshot : this.loadSnapshots()) {
            this.snapshots.put(snapshot.index(), snapshot);
        }
        if (!this.snapshots.isEmpty()) {
            this.currentSnapshot = this.snapshots.lastEntry().getValue();
        }
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public Snapshot currentSnapshot() {
        return this.currentSnapshot;
    }

    public Collection<Snapshot> snapshots() {
        return this.snapshots.values();
    }

    public Snapshot snapshot(long index) {
        return this.snapshots.get(index);
    }

    private Collection<Snapshot> loadSnapshots() {
        this.storage.directory().mkdirs();
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        for (File file : this.storage.directory().listFiles(File::isFile)) {
            if (!SnapshotFile.isSnapshotFile(this.name, file)) continue;
            SnapshotFile snapshotFile = new SnapshotFile(file);
            SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)FileBuffer.allocate((File)file, (long)64L));
            if (descriptor.locked()) {
                LOGGER.debug("Loaded disk snapshot: {} ({})", (Object)snapshotFile.index(), (Object)snapshotFile.file().getName());
                snapshots.add(new FileSnapshot(snapshotFile, this));
                descriptor.close();
                continue;
            }
            LOGGER.debug("Deleting partial snapshot: {} ({})", (Object)descriptor.index(), (Object)snapshotFile.file().getName());
            descriptor.close();
            descriptor.delete();
        }
        return snapshots;
    }

    public Snapshot createSnapshot(long index) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withIndex(index).withTimestamp(System.currentTimeMillis()).build();
        return this.createSnapshot(descriptor);
    }

    private Snapshot createSnapshot(SnapshotDescriptor descriptor) {
        if (this.storage.level() == StorageLevel.MEMORY) {
            return this.createMemorySnapshot(descriptor);
        }
        return this.createDiskSnapshot(descriptor);
    }

    private Snapshot createMemorySnapshot(SnapshotDescriptor descriptor) {
        HeapBuffer buffer = HeapBuffer.allocate((long)64L, (long)Integer.MAX_VALUE);
        MemorySnapshot snapshot = new MemorySnapshot(buffer, descriptor.copyTo((Buffer)buffer), this);
        LOGGER.debug("Created memory snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    private Snapshot createDiskSnapshot(SnapshotDescriptor descriptor) {
        SnapshotFile file = new SnapshotFile(SnapshotFile.createSnapshotFile(this.name, this.storage.directory(), descriptor.index(), descriptor.timestamp()));
        FileSnapshot snapshot = new FileSnapshot(file, this);
        LOGGER.debug("Created disk snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    protected void completeSnapshot(Snapshot snapshot) {
        Assert.notNull((Object)snapshot, (String)"snapshot");
        this.snapshots.put(snapshot.index(), snapshot);
        if (this.currentSnapshot == null || snapshot.index() > this.currentSnapshot.index()) {
            this.currentSnapshot = snapshot;
        }
        if (!this.storage.retainStaleSnapshots()) {
            Iterator<Map.Entry<Long, Snapshot>> iterator = this.snapshots.entrySet().iterator();
            while (iterator.hasNext()) {
                Snapshot oldSnapshot = iterator.next().getValue();
                if (oldSnapshot.index() >= this.currentSnapshot.index()) continue;
                iterator.remove();
                oldSnapshot.close();
                oldSnapshot.delete();
            }
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

