/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.state.AbstractAppender;
import io.atomix.copycat.server.state.MemberState;
import io.atomix.copycat.server.state.ServerContext;

final class FollowerAppender
extends AbstractAppender {
    public FollowerAppender(ServerContext context) {
        super(context);
    }

    public void appendEntries() {
        if (this.open) {
            for (MemberState member : this.context.getClusterState().getAssignedPassiveMemberStates()) {
                this.appendEntries(member);
            }
        }
    }

    @Override
    protected boolean hasMoreEntries(MemberState member) {
        return member.getMember().type() == Member.Type.PASSIVE && member.getNextIndex() <= this.context.getCommitIndex();
    }

    @Override
    protected void appendEntries(MemberState member) {
        if (!this.open) {
            return;
        }
        if (this.context.getSnapshotStore().currentSnapshot() != null && this.context.getSnapshotStore().currentSnapshot().index() >= member.getNextIndex() && this.context.getSnapshotStore().currentSnapshot().index() > member.getSnapshotIndex()) {
            if (member.canInstall()) {
                this.sendInstallRequest(member, this.buildInstallRequest(member));
            }
        } else if (member.canAppend() && this.hasMoreEntries(member)) {
            this.sendAppendRequest(member, this.buildAppendRequest(member, Math.min(this.context.getCommitIndex(), this.context.getLog().lastIndex())));
        }
    }
}

