/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.SessionResponse;
import java.util.Objects;

public abstract class OperationResponse
extends SessionResponse {
    protected long index;
    protected long eventIndex;
    protected Object result;
    protected long lastSequence;

    public long index() {
        return this.index;
    }

    public long eventIndex() {
        return this.eventIndex;
    }

    public Object result() {
        return this.result;
    }

    public long lastSequence() {
        return this.lastSequence;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        this.index = buffer.readLong();
        this.eventIndex = buffer.readLong();
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.result = serializer.readObject(buffer);
        } else {
            this.error = CopycatError.forId(buffer.readByte());
            this.lastSequence = buffer.readLong();
        }
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte((int)this.status.id());
        buffer.writeLong(this.index);
        buffer.writeLong(this.eventIndex);
        if (this.status == Response.Status.OK) {
            serializer.writeObject(this.result, buffer);
        } else {
            buffer.writeByte((int)this.error.id());
            buffer.writeLong(this.lastSequence);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.result});
    }

    public boolean equals(Object object) {
        if (this.getClass().isAssignableFrom(object.getClass())) {
            OperationResponse response = (OperationResponse)object;
            return response.status == this.status && response.index == this.index && response.eventIndex == this.eventIndex && response.lastSequence == this.lastSequence && (response.result == null && this.result == null || response.result != null && this.result != null && response.result.equals(this.result));
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.error == null) {
            return String.format("%s[status=%s, index=%d, eventIndex=%d, result=%s]", new Object[]{this.getClass().getSimpleName(), this.status, this.index, this.eventIndex, this.result});
        }
        return String.format("%s[status=%s, error=%s, lastSequence=%d]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.lastSequence});
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends OperationResponse>
    extends SessionResponse.Builder<T, U> {
        protected Builder(U response) {
            super(response);
        }

        public T withIndex(long index) {
            ((OperationResponse)this.response).index = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"index must be positive", (Object[])new Object[0]);
            return (T)this;
        }

        public T withEventIndex(long eventIndex) {
            ((OperationResponse)this.response).eventIndex = (Long)Assert.argNot((Object)eventIndex, (eventIndex < 0L ? 1 : 0) != 0, (String)"eventIndex must be positive", (Object[])new Object[0]);
            return (T)this;
        }

        public T withResult(Object result) {
            ((OperationResponse)this.response).result = result;
            return (T)this;
        }

        public T withLastSequence(long lastSequence) {
            ((OperationResponse)this.response).lastSequence = (Long)Assert.arg((Object)lastSequence, (lastSequence >= 0L ? 1 : 0) != 0, (String)"lastSequence must be positive", (Object[])new Object[0]);
            return (T)this;
        }

        @Override
        public U build() {
            super.build();
            if (((OperationResponse)this.response).status == Response.Status.OK) {
                Assert.stateNot((((OperationResponse)this.response).index < 0L ? 1 : 0) != 0, (String)"index cannot be less than 0", (Object[])new Object[0]);
            }
            return (U)((OperationResponse)this.response);
        }
    }
}

