/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.ByteBufferBuffer;
import io.atomix.catalyst.buffer.HeapBytes;
import io.atomix.catalyst.buffer.util.Memory;

public class HeapBuffer
extends ByteBufferBuffer {
    public static HeapBuffer allocate() {
        return HeapBuffer.allocate(4096L, Integer.MAX_VALUE);
    }

    public static HeapBuffer allocate(long initialCapacity) {
        return HeapBuffer.allocate(initialCapacity, Integer.MAX_VALUE);
    }

    public static HeapBuffer allocate(long initialCapacity, long maxCapacity) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        return new HeapBuffer(HeapBytes.allocate((int)Math.min(Memory.Util.toPow2(initialCapacity), Integer.MAX_VALUE)), 0L, initialCapacity, maxCapacity);
    }

    public static HeapBuffer wrap(byte[] bytes) {
        return new HeapBuffer(HeapBytes.wrap(bytes), 0L, bytes.length, bytes.length);
    }

    protected HeapBuffer(HeapBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

