/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBytes;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.UnsafeMappedBytes;
import io.atomix.catalyst.buffer.WrappedBytes;
import io.atomix.catalyst.buffer.util.MappedMemoryAllocator;
import io.atomix.catalyst.buffer.util.Memory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;

public class FileBytes
extends AbstractBytes {
    static final String DEFAULT_MODE = "rw";
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private long size;

    public static FileBytes allocate(File file) {
        return FileBytes.allocate(file, DEFAULT_MODE, Long.MAX_VALUE);
    }

    public static FileBytes allocate(File file, long size) {
        return FileBytes.allocate(file, DEFAULT_MODE, size);
    }

    public static FileBytes allocate(File file, String mode, long size) {
        return new FileBytes(file, mode, Memory.Util.toPow2(size));
    }

    FileBytes(File file, String mode, long size) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = DEFAULT_MODE;
        }
        if (size < 0L) {
            throw new IllegalArgumentException("size must be positive");
        }
        this.file = file;
        this.size = size;
        try {
            this.randomAccessFile = new RandomAccessFile(file, mode);
            if (size > this.randomAccessFile.length()) {
                this.randomAccessFile.setLength(size);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File file() {
        return this.file;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Bytes resize(long newSize) {
        if (newSize < this.size) {
            throw new IllegalArgumentException("cannot decrease file bytes size; use zero() to decrease file size");
        }
        this.size = newSize;
        try {
            long length = this.randomAccessFile.length();
            if (this.size > length) {
                this.randomAccessFile.setLength(newSize);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public UnsafeMappedBytes map(long offset, long size) {
        return this.map(offset, size, FileChannel.MapMode.READ_WRITE);
    }

    public UnsafeMappedBytes map(long offset, long size, FileChannel.MapMode mode) {
        return new UnsafeMappedBytes(this.file, new MappedMemoryAllocator(this.randomAccessFile, mode, offset).allocate(size));
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    private void seekToOffset(long offset) throws IOException {
        if (this.randomAccessFile.getFilePointer() != offset) {
            this.randomAccessFile.seek(offset);
        }
    }

    @Override
    public Bytes zero() {
        try {
            this.randomAccessFile.setLength(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes zero(long offset) {
        try {
            this.randomAccessFile.setLength(offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes zero(long offset, long length) {
        for (long i = offset; i < offset + length; ++i) {
            this.writeByte(i, 0);
        }
        return this;
    }

    @Override
    public Bytes read(long position, Bytes bytes, long offset, long length) {
        this.checkRead(position, length);
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes.hasArray()) {
            try {
                this.seekToOffset(position);
                this.randomAccessFile.read(bytes.array(), (int)offset, (int)length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.seekToOffset(position);
            byte[] readBytes = new byte[(int)length];
            this.randomAccessFile.read(readBytes);
            bytes.write(offset, readBytes, 0L, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes read(long position, byte[] bytes, long offset, long length) {
        this.checkRead(position, length);
        try {
            this.seekToOffset(position);
            this.randomAccessFile.read(bytes, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public int readByte(long offset) {
        this.checkRead(offset, 1L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public char readChar(long offset) {
        this.checkRead(offset, 2L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readChar();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public short readShort(long offset) {
        this.checkRead(offset, 2L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readShort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int readInt(long offset) {
        this.checkRead(offset, 4L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long readLong(long offset) {
        this.checkRead(offset, 8L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public float readFloat(long offset) {
        this.checkRead(offset, 4L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDouble(long offset) {
        this.checkRead(offset, 8L);
        try {
            this.seekToOffset(offset);
            return this.randomAccessFile.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Bytes write(long position, Bytes bytes, long offset, long length) {
        this.checkWrite(position, length);
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes.hasArray()) {
            try {
                this.seekToOffset(position);
                this.randomAccessFile.write(bytes.array(), (int)offset, (int)length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.seekToOffset(position);
            byte[] writeBytes = new byte[(int)length];
            bytes.read(offset, writeBytes, 0L, length);
            this.randomAccessFile.write(writeBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes write(long position, byte[] bytes, long offset, long length) {
        this.checkWrite(position, length);
        try {
            this.seekToOffset(position);
            this.randomAccessFile.write(bytes, (int)offset, (int)length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeByte(long offset, int b) {
        this.checkWrite(offset, 1L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeChar(long offset, char c) {
        this.checkWrite(offset, 2L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short s) {
        this.checkWrite(offset, 2L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.checkWrite(offset, 4L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeLong(long offset, long l) {
        this.checkWrite(offset, 8L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float f) {
        this.checkWrite(offset, 4L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        this.checkWrite(offset, 8L);
        try {
            this.seekToOffset(offset);
            this.randomAccessFile.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Bytes flush() {
        try {
            this.randomAccessFile.getFD().sync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.close();
    }

    public void delete() {
        try {
            this.close();
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

