/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.session;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;

public class Event<T>
implements CatalystSerializable {
    private String event;
    private Object message;

    public Event() {
    }

    public Event(String event, Object message) {
        this.event = event;
        this.message = message;
    }

    public String name() {
        return this.event;
    }

    public T message() {
        return (T)this.message;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUTF8(this.event);
        serializer.writeObject(this.message, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.event = buffer.readUTF8();
        this.message = serializer.readObject(buffer);
    }

    public String toString() {
        return String.format("%s[event=%s, message=%s]", this.getClass().getSimpleName(), this.event, this.message);
    }
}

