/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.util.Assert;
import io.atomix.collections.DistributedMap;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import java.util.Collection;
import java.util.Set;

public class MapCommands {
    private MapCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(ContainsKey.class, -65);
            registry.register(ContainsValue.class, -66);
            registry.register(Put.class, -67);
            registry.register(PutIfAbsent.class, -68);
            registry.register(Get.class, -69);
            registry.register(GetOrDefault.class, -70);
            registry.register(Remove.class, -71);
            registry.register(RemoveIfPresent.class, -72);
            registry.register(Replace.class, -73);
            registry.register(ReplaceIfPresent.class, -74);
            registry.register(Values.class, -155);
            registry.register(KeySet.class, -156);
            registry.register(EntrySet.class, -157);
            registry.register(IsEmpty.class, -75);
            registry.register(Size.class, -76);
            registry.register(Clear.class, -77);
            registry.register(DistributedMap.EntryEvent.class, -78);
            registry.register(KeyListen.class, -168);
            registry.register(KeyUnlisten.class, -169);
        }
    }

    public static class KeyUnlisten
    extends EventCommand {
        public KeyUnlisten() {
        }

        public KeyUnlisten(int event, Object key) {
            super(event, key);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.TOMBSTONE;
        }
    }

    public static class KeyListen
    extends EventCommand {
        public KeyListen() {
        }

        public KeyListen(int event, Object key) {
            super(event, key);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }
    }

    public static abstract class EventCommand
    extends MapCommand<Void> {
        private int event;
        private Object key;

        protected EventCommand() {
        }

        protected EventCommand(int event, Object key) {
            this.event = event;
            this.key = key;
        }

        public int event() {
            return this.event;
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeByte(this.event);
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.event = buffer.readByte();
            this.key = serializer.readObject(buffer);
        }
    }

    public static class Clear
    extends MapCommand<Void> {
        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class EntrySet
    extends MapQuery<Set> {
        public EntrySet() {
        }

        public EntrySet(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class KeySet
    extends MapQuery<Set> {
        public KeySet() {
        }

        public KeySet(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class Values
    extends MapQuery<Collection> {
        public Values() {
        }

        public Values(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class Size
    extends MapQuery<Integer> {
        public Size() {
        }

        public Size(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class IsEmpty
    extends MapQuery<Boolean> {
        public IsEmpty() {
        }

        public IsEmpty(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static class ReplaceIfPresent
    extends TtlCommand<Boolean> {
        private Object replace;

        public ReplaceIfPresent() {
        }

        public ReplaceIfPresent(Object key, Object replace, Object value) {
            this(key, replace, value, 0L);
        }

        public ReplaceIfPresent(Object key, Object replace, Object value, long ttl) {
            super(key, value, ttl);
            this.replace = replace;
        }

        public Object replace() {
            return this.replace;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.replace, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.replace = serializer.readObject(buffer);
        }
    }

    public static class Replace
    extends TtlCommand<Object> {
        public Replace() {
        }

        public Replace(Object key, Object value) {
            this(key, value, 0L);
        }

        public Replace(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    public static class RemoveIfPresent
    extends KeyValueCommand<Boolean> {
        public RemoveIfPresent() {
        }

        public RemoveIfPresent(Object key, Object value) {
            super(key, value);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Remove
    extends KeyCommand<Object> {
        public Remove() {
        }

        public Remove(Object key) {
            super(key);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class GetOrDefault
    extends KeyQuery<Object> {
        private Object defaultValue;

        public GetOrDefault() {
        }

        public GetOrDefault(Object key, Object defaultValue) {
            super(key);
            this.defaultValue = defaultValue;
        }

        public GetOrDefault(Object key, Object defaultValue, Query.ConsistencyLevel consistency) {
            super(key, consistency);
            this.defaultValue = defaultValue;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.defaultValue = serializer.readObject(buffer);
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.defaultValue, buffer);
        }
    }

    public static class Get
    extends KeyQuery<Object> {
        public Get() {
        }

        public Get(Object key) {
            super(key);
        }

        public Get(Object key, Query.ConsistencyLevel consistency) {
            super(key, consistency);
        }
    }

    public static class PutIfAbsent
    extends TtlCommand<Object> {
        public PutIfAbsent() {
        }

        public PutIfAbsent(Object key, Object value) {
            this(key, value, 0L);
        }

        public PutIfAbsent(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    public static class Put
    extends TtlCommand<Object> {
        public Put() {
        }

        public Put(Object key, Object value) {
            this(key, value, 0L);
        }

        public Put(Object key, Object value, long ttl) {
            super(key, value, ttl);
        }
    }

    public static abstract class TtlCommand<V>
    extends KeyValueCommand<V> {
        protected long ttl;

        public TtlCommand() {
        }

        public TtlCommand(Object key, Object value, long ttl) {
            super(key, value);
            this.ttl = ttl;
        }

        @Override
        public Command.CompactionMode compaction() {
            return this.ttl > 0L ? Command.CompactionMode.EXPIRING : Command.CompactionMode.QUORUM;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.ttl = buffer.readLong();
        }
    }

    public static abstract class KeyValueCommand<V>
    extends KeyCommand<V> {
        protected Object value;

        public KeyValueCommand() {
        }

        public KeyValueCommand(Object key, Object value) {
            super(key);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static class ContainsValue
    extends MapQuery<Boolean> {
        protected Object value;

        public ContainsValue() {
        }

        public ContainsValue(Object value) {
            this.value = Assert.notNull((Object)value, (String)"value");
        }

        public ContainsValue(Object value, Query.ConsistencyLevel consistency) {
            super(consistency);
            this.value = Assert.notNull((Object)value, (String)"value");
        }

        public Object value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.value = serializer.readObject(buffer);
        }
    }

    public static class ContainsKey
    extends KeyQuery<Boolean> {
        public ContainsKey() {
        }

        public ContainsKey(Object key) {
            super(key);
        }

        public ContainsKey(Object key, Query.ConsistencyLevel consistency) {
            super(key, consistency);
        }
    }

    public static abstract class KeyQuery<V>
    extends MapQuery<V> {
        protected Object key;

        public KeyQuery() {
        }

        public KeyQuery(Object key) {
            this.key = Assert.notNull((Object)key, (String)"key");
        }

        public KeyQuery(Object key, Query.ConsistencyLevel consistency) {
            super(consistency);
            this.key = Assert.notNull((Object)key, (String)"key");
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.key = serializer.readObject(buffer);
        }
    }

    public static abstract class KeyCommand<V>
    extends MapCommand<V> {
        protected Object key;

        public KeyCommand() {
        }

        public KeyCommand(Object key) {
            this.key = Assert.notNull((Object)key, (String)"key");
        }

        public Object key() {
            return this.key;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.key, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.key = serializer.readObject(buffer);
        }
    }

    public static abstract class MapQuery<V>
    implements Query<V>,
    CatalystSerializable {
        protected Query.ConsistencyLevel consistency;

        protected MapQuery() {
        }

        protected MapQuery(Query.ConsistencyLevel consistency) {
            this.consistency = consistency;
        }

        public void writeObject(BufferOutput<?> output, Serializer serializer) {
            if (this.consistency != null) {
                output.writeByte(this.consistency.ordinal());
            } else {
                output.writeByte(-1);
            }
        }

        public void readObject(BufferInput<?> input, Serializer serializer) {
            int ordinal = input.readByte();
            if (ordinal != -1) {
                this.consistency = Query.ConsistencyLevel.values()[ordinal];
            }
        }
    }

    public static abstract class MapCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

