/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.ByteBufferBuffer;
import io.atomix.catalyst.buffer.DirectBytes;
import io.atomix.catalyst.buffer.util.Memory;

public class DirectBuffer
extends ByteBufferBuffer {
    public static DirectBuffer allocate() {
        return DirectBuffer.allocate(4096L, Integer.MAX_VALUE);
    }

    public static DirectBuffer allocate(long initialCapacity) {
        return DirectBuffer.allocate(initialCapacity, Integer.MAX_VALUE);
    }

    public static DirectBuffer allocate(long initialCapacity, long maxCapacity) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        return new DirectBuffer(DirectBytes.allocate((int)Math.min(Memory.Util.toPow2(initialCapacity), Integer.MAX_VALUE)), 0L, initialCapacity, maxCapacity);
    }

    protected DirectBuffer(DirectBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
    }
}

