/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Storage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.Predicate;

public class StorageCleaner {
    private final Storage storage;

    public StorageCleaner(Storage storage) {
        this.storage = (Storage)Assert.notNull((Object)storage, (String)"storage");
    }

    public void cleanFiles(Predicate<File> predicate) {
        this.storage.directory().mkdirs();
        for (File file : this.storage.directory().listFiles(f -> f.isFile() && predicate.test(f))) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

