/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.protocol.ReconfigureRequest;
import io.atomix.copycat.server.state.ClusterState;
import io.atomix.copycat.server.storage.system.Configuration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class ServerMember
implements Member,
CatalystSerializable,
AutoCloseable {
    private Member.Type type;
    private Member.Status status = Member.Status.AVAILABLE;
    private Instant updated;
    private Address serverAddress;
    private Address clientAddress;
    private transient Scheduled configureTimeout;
    private transient ClusterState cluster;
    private transient Listeners<Member.Type> typeChangeListeners;
    private transient Listeners<Member.Status> statusChangeListeners;

    ServerMember() {
    }

    public ServerMember(Member.Type type, Address serverAddress, Address clientAddress, Instant updated) {
        this.type = (Member.Type)((Object)Assert.notNull((Object)((Object)type), (String)"type"));
        this.serverAddress = (Address)Assert.notNull((Object)serverAddress, (String)"serverAddress");
        this.clientAddress = clientAddress;
        this.updated = (Instant)Assert.notNull((Object)updated, (String)"updated");
    }

    ServerMember setCluster(ClusterState cluster) {
        this.cluster = cluster;
        return this;
    }

    @Override
    public int id() {
        return this.hashCode();
    }

    @Override
    public Member.Type type() {
        return this.type;
    }

    @Override
    public Member.Status status() {
        return this.status;
    }

    @Override
    public Instant updated() {
        return this.updated;
    }

    @Override
    public Address address() {
        return this.serverAddress();
    }

    @Override
    public Address serverAddress() {
        return this.serverAddress;
    }

    @Override
    public Address clientAddress() {
        return this.clientAddress;
    }

    @Override
    public Listener<Member.Type> onTypeChange(Consumer<Member.Type> callback) {
        if (this.typeChangeListeners == null) {
            this.typeChangeListeners = new Listeners();
        }
        return this.typeChangeListeners.add(callback);
    }

    @Override
    public Listener<Member.Status> onStatusChange(Consumer<Member.Status> callback) {
        if (this.statusChangeListeners == null) {
            this.statusChangeListeners = new Listeners();
        }
        return this.statusChangeListeners.add(callback);
    }

    @Override
    public CompletableFuture<Void> promote() {
        return this.configure(Member.Type.values()[this.type.ordinal() + 1]);
    }

    @Override
    public CompletableFuture<Void> promote(Member.Type type) {
        return this.configure(type);
    }

    @Override
    public CompletableFuture<Void> demote() {
        return this.configure(Member.Type.values()[this.type.ordinal() - 1]);
    }

    @Override
    public CompletableFuture<Void> demote(Member.Type type) {
        return this.configure(type);
    }

    @Override
    public CompletableFuture<Void> remove() {
        return this.configure(Member.Type.INACTIVE);
    }

    ServerMember update(Member.Type type, Instant time) {
        if (this.type != type) {
            this.type = (Member.Type)((Object)Assert.notNull((Object)((Object)type), (String)"type"));
            if (time.isAfter(this.updated)) {
                this.updated = (Instant)Assert.notNull((Object)time, (String)"time");
            }
            if (this.typeChangeListeners != null) {
                this.typeChangeListeners.accept((Object)type);
            }
        }
        return this;
    }

    ServerMember update(Member.Status status, Instant time) {
        if (this.status != status) {
            this.status = (Member.Status)((Object)Assert.notNull((Object)((Object)status), (String)"status"));
            if (time.isAfter(this.updated)) {
                this.updated = (Instant)Assert.notNull((Object)time, (String)"time");
            }
            if (this.statusChangeListeners != null) {
                this.statusChangeListeners.accept((Object)status);
            }
        }
        return this;
    }

    ServerMember update(Address clientAddress, Instant time) {
        if (clientAddress != null) {
            this.clientAddress = clientAddress;
            if (time.isAfter(this.updated)) {
                this.updated = (Instant)Assert.notNull((Object)time, (String)"time");
            }
        }
        return this;
    }

    CompletableFuture<Void> configure(Member.Type type) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.cluster.getContext().getThreadContext().executor().execute(() -> this.configure(type, future));
        return future;
    }

    private void configure(Member.Type type, CompletableFuture<Void> future) {
        this.configureTimeout = this.cluster.getContext().getThreadContext().schedule(this.cluster.getContext().getElectionTimeout(), () -> this.configure(type, future));
        this.cluster.getContext().getServerState().reconfigure((ReconfigureRequest)((ReconfigureRequest.Builder)((Object)ReconfigureRequest.builder().withIndex(this.cluster.getConfiguration().index()).withTerm(this.cluster.getConfiguration().term()).withMember(new ServerMember(type, this.serverAddress(), this.clientAddress(), this.updated)))).build()).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == Response.Status.OK) {
                    this.cancelConfigureTimer();
                    this.cluster.configure(new Configuration(response.index(), response.term(), response.timestamp(), response.members()));
                    future.complete(null);
                } else if (response.error() == null || response.error() == CopycatError.Type.NO_LEADER_ERROR) {
                    this.cancelConfigureTimer();
                    this.configureTimeout = this.cluster.getContext().getThreadContext().schedule(this.cluster.getContext().getElectionTimeout().multipliedBy(2L), () -> this.configure(type, future));
                } else {
                    this.cancelConfigureTimer();
                    future.completeExceptionally((Throwable)response.error().createException());
                }
            }
        });
    }

    private void cancelConfigureTimer() {
        if (this.configureTimeout != null) {
            this.configureTimeout.cancel();
            this.configureTimeout = null;
        }
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeByte(this.type.ordinal());
        buffer.writeByte(this.status.ordinal());
        buffer.writeLong(this.updated.toEpochMilli());
        serializer.writeObject((Object)this.serverAddress, buffer);
        serializer.writeObject((Object)this.clientAddress, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.type = Member.Type.values()[buffer.readByte()];
        this.status = Member.Status.values()[buffer.readByte()];
        this.updated = Instant.ofEpochMilli(buffer.readLong());
        this.serverAddress = (Address)serializer.readObject(buffer);
        this.clientAddress = (Address)serializer.readObject(buffer);
    }

    @Override
    public void close() {
        this.cancelConfigureTimer();
    }

    public int hashCode() {
        return this.serverAddress.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ServerMember && ((ServerMember)object).serverAddress().equals((Object)this.serverAddress);
    }

    public String toString() {
        return String.format("%s[type=%s, status=%s, serverAddress=%s, clientAddress=%s]", new Object[]{this.getClass().getSimpleName(), this.type, this.status, this.serverAddress, this.clientAddress});
    }
}

