/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport.netty;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.buffer.Bytes;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

final class ByteBufOutput
implements BufferOutput<ByteBufOutput> {
    ByteBuf buffer;

    ByteBufOutput() {
    }

    ByteBufOutput setByteBuf(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    private void checkWrite(int size) {
        if (this.buffer.writerIndex() + size > this.buffer.maxCapacity()) {
            this.buffer.discardSomeReadBytes();
            if (this.buffer.writerIndex() + size > this.buffer.maxCapacity()) {
                this.buffer.discardReadBytes();
            }
        }
    }

    public ByteBufOutput write(Buffer buffer) {
        int size = Math.min((int)buffer.remaining(), this.buffer.writableBytes());
        this.checkWrite(size);
        byte[] bytes = new byte[size];
        buffer.read(bytes);
        this.buffer.writeBytes(bytes);
        return this;
    }

    public ByteBufOutput write(Bytes bytes) {
        int size = Math.min((int)bytes.size(), this.buffer.writableBytes());
        this.checkWrite(size);
        byte[] b = new byte[size];
        bytes.read(0L, b, 0L, (long)b.length);
        this.buffer.writeBytes(b);
        return this;
    }

    public ByteBufOutput write(byte[] bytes) {
        this.checkWrite(bytes.length);
        this.buffer.writeBytes(bytes);
        return this;
    }

    public ByteBufOutput write(Bytes bytes, long offset, long length) {
        int size = Math.min((int)bytes.size(), (int)length);
        this.checkWrite(size);
        byte[] b = new byte[size];
        bytes.read(offset, b, 0L, (long)b.length);
        this.buffer.writeBytes(b);
        return this;
    }

    public ByteBufOutput write(byte[] bytes, long offset, long length) {
        this.checkWrite((int)length);
        this.buffer.writeBytes(bytes, (int)offset, (int)length);
        return this;
    }

    public ByteBufOutput writeByte(int b) {
        this.checkWrite(1);
        this.buffer.writeByte(b);
        return this;
    }

    public ByteBufOutput writeUnsignedByte(int b) {
        this.checkWrite(1);
        this.buffer.writeByte(b);
        return this;
    }

    public ByteBufOutput writeChar(char c) {
        this.checkWrite(2);
        this.buffer.writeChar((int)c);
        return this;
    }

    public ByteBufOutput writeShort(short s) {
        this.checkWrite(2);
        this.buffer.writeShort((int)s);
        return this;
    }

    public ByteBufOutput writeUnsignedShort(int s) {
        this.checkWrite(2);
        this.buffer.writeShort(s);
        return this;
    }

    public ByteBufOutput writeInt(int i) {
        this.checkWrite(4);
        this.buffer.writeInt(i);
        return this;
    }

    public ByteBufOutput writeUnsignedInt(long i) {
        this.checkWrite(4);
        this.buffer.writeInt((int)i);
        return this;
    }

    public ByteBufOutput writeMedium(int m) {
        this.checkWrite(3);
        this.buffer.writeMedium(m);
        return this;
    }

    public ByteBufOutput writeUnsignedMedium(int m) {
        this.checkWrite(3);
        this.buffer.writeMedium(m);
        return this;
    }

    public ByteBufOutput writeLong(long l) {
        this.checkWrite(8);
        this.buffer.writeLong(l);
        return this;
    }

    public ByteBufOutput writeFloat(float f) {
        this.checkWrite(4);
        this.buffer.writeFloat(f);
        return this;
    }

    public ByteBufOutput writeDouble(double d) {
        this.checkWrite(8);
        this.buffer.writeDouble(d);
        return this;
    }

    public ByteBufOutput writeBoolean(boolean b) {
        this.checkWrite(1);
        this.buffer.writeBoolean(b);
        return this;
    }

    public ByteBufOutput writeString(String s) {
        return this.writeString(s, Charset.defaultCharset());
    }

    public ByteBufOutput writeString(String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(Boolean.FALSE);
        }
        byte[] bytes = s.getBytes(charset);
        this.writeBoolean(Boolean.TRUE);
        return this.writeUnsignedShort(bytes.length).write(bytes, 0L, (long)bytes.length);
    }

    public ByteBufOutput writeUTF8(String s) {
        return this.writeString(s, StandardCharsets.UTF_8);
    }

    public ByteBufOutput flush() {
        return this;
    }

    public void close() {
    }
}

