/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.util.Assert;
import java.io.File;

public final class SegmentFile {
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private final File file;

    public static boolean isSegmentFile(String name, File file) {
        int i;
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)file, (String)"file");
        String fileName = file.getName();
        if (fileName.lastIndexOf(46) == -1 || fileName.lastIndexOf(45) == -1 || fileName.lastIndexOf(46) < fileName.lastIndexOf(45) || !fileName.endsWith(EXTENSION)) {
            return false;
        }
        for (i = fileName.lastIndexOf(45) + 1; i < fileName.lastIndexOf(46); ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        if (fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1) == -1) {
            return false;
        }
        for (i = fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1) + 1; i < fileName.lastIndexOf(45); ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return fileName.substring(0, fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1)).equals(name);
    }

    static File createSegmentFile(String name, File directory, long id, long version) {
        return new File(directory, String.format("%s-%d-%d.log", Assert.notNull((Object)name, (String)"name"), id, version));
    }

    SegmentFile(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public long id() {
        return Long.valueOf(this.file.getName().substring(this.file.getName().lastIndexOf(45, this.file.getName().lastIndexOf(45) - 1) + 1, this.file.getName().lastIndexOf(45)));
    }

    public long version() {
        return Long.valueOf(this.file.getName().substring(this.file.getName().lastIndexOf(45) + 1, this.file.getName().lastIndexOf(46)));
    }
}

