/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import io.atomix.copycat.server.storage.entry.Entry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AppendRequest
extends AbstractRequest {
    private long term;
    private int leader;
    private long logIndex;
    private long logTerm;
    private List<Entry> entries;
    private long commitIndex = -1L;
    private long globalIndex = -1L;

    public static Builder builder() {
        return new Builder(new AppendRequest());
    }

    public static Builder builder(AppendRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public int leader() {
        return this.leader;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public long logTerm() {
        return this.logTerm;
    }

    public List<? extends Entry> entries() {
        return this.entries;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public long globalIndex() {
        return this.globalIndex;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.term).writeInt(this.leader).writeLong(this.logIndex).writeLong(this.logTerm).writeLong(this.commitIndex).writeLong(this.globalIndex);
        buffer.writeInt(this.entries.size());
        for (Entry entry : this.entries) {
            buffer.writeLong(entry.getIndex()).writeLong(entry.getTerm());
            serializer.writeObject((Object)entry, buffer);
        }
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.term = buffer.readLong();
        this.leader = buffer.readInt();
        this.logIndex = buffer.readLong();
        this.logTerm = buffer.readLong();
        this.commitIndex = buffer.readLong();
        this.globalIndex = buffer.readLong();
        int numEntries = buffer.readInt();
        this.entries = new ArrayList<Entry>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            long index = buffer.readLong();
            long term = buffer.readLong();
            Entry entry = (Entry)serializer.readObject(buffer);
            ((Entry)entry.setIndex(index)).setTerm(term);
            this.entries.add(entry);
        }
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.term, this.leader, this.logIndex, this.logTerm, this.entries, this.commitIndex, this.globalIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof AppendRequest) {
            AppendRequest request = (AppendRequest)((Object)object);
            return request.term == this.term && request.leader == this.leader && request.logIndex == this.logIndex && request.logTerm == this.logTerm && request.entries.equals(this.entries) && request.commitIndex == this.commitIndex && request.globalIndex == this.globalIndex;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[term=%d, leader=%s, logIndex=%d, logTerm=%d, entries=[%d], commitIndex=%d, globalIndex=%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.term, this.leader, this.logIndex, this.logTerm, this.entries.size(), this.commitIndex, this.globalIndex);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, AppendRequest> {
        protected Builder(AppendRequest request) {
            super((AbstractRequest)request);
        }

        public Builder withTerm(long term) {
            ((AppendRequest)this.request).term = (Long)Assert.arg((Object)term, (term > 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withLeader(int leader) {
            ((AppendRequest)this.request).leader = leader;
            return this;
        }

        public Builder withLogIndex(long index) {
            ((AppendRequest)this.request).logIndex = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"log index must be not be negative", (Object[])new Object[0]);
            return this;
        }

        public Builder withLogTerm(long term) {
            ((AppendRequest)this.request).logTerm = (Long)Assert.argNot((Object)term, (term < 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            return this;
        }

        public Builder withEntries(Entry ... entries) {
            return this.withEntries(Arrays.asList((Object[])Assert.notNull((Object)entries, (String)"entries")));
        }

        public Builder withEntries(List<? extends Entry> entries) {
            ((AppendRequest)this.request).entries = (List)Assert.notNull(entries, (String)"entries");
            return this;
        }

        public Builder addEntry(Entry entry) {
            ((AppendRequest)this.request).entries.add(Assert.notNull((Object)entry, (String)"entry"));
            return this;
        }

        public Builder withCommitIndex(long index) {
            ((AppendRequest)this.request).commitIndex = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"commit index must not be negative", (Object[])new Object[0]);
            return this;
        }

        public Builder withGlobalIndex(long index) {
            ((AppendRequest)this.request).globalIndex = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"global index must not be negative", (Object[])new Object[0]);
            return this;
        }

        public AppendRequest build() {
            super.build();
            Assert.stateNot((((AppendRequest)this.request).term <= 0L ? 1 : 0) != 0, (String)"term must be positive", (Object[])new Object[0]);
            Assert.stateNot((((AppendRequest)this.request).logIndex < 0L ? 1 : 0) != 0, (String)"log index must not be negative", (Object[])new Object[0]);
            if (((AppendRequest)this.request).logIndex > 0L) {
                Assert.stateNot((((AppendRequest)this.request).logTerm == 0L ? 1 : 0) != 0, (String)"log term must be specified", (Object[])new Object[0]);
            } else {
                Assert.stateNot((((AppendRequest)this.request).logTerm < 0L ? 1 : 0) != 0, (String)"log term must not be negative", (Object[])new Object[0]);
            }
            Assert.stateNot((((AppendRequest)this.request).entries == null ? 1 : 0) != 0, (String)"entries cannot be null", (Object[])new Object[0]);
            Assert.stateNot((((AppendRequest)this.request).commitIndex < 0L ? 1 : 0) != 0, (String)"commit index must not be negative", (Object[])new Object[0]);
            Assert.stateNot((((AppendRequest)this.request).globalIndex < 0L ? 1 : 0) != 0, (String)"global index must not be negative", (Object[])new Object[0]);
            return (AppendRequest)this.request;
        }

        public int hashCode() {
            return Objects.hash(this.request);
        }

        public boolean equals(Object object) {
            return object instanceof Builder && ((AppendRequest)((Builder)((Object)object)).request).equals(this.request);
        }

        public String toString() {
            return String.format("%s[request=%s]", ((Object)((Object)this)).getClass().getCanonicalName(), this.request);
        }
    }
}

