/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.BufferInput;
import java.io.IOException;
import java.io.InputStream;

public class BufferInputStream
extends InputStream {
    private final BufferInput<?> buffer;

    public BufferInputStream(BufferInput<?> buffer) {
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.readByte();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.buffer.hasRemaining()) {
            int read = Math.min(b.length, (int)this.buffer.remaining());
            this.buffer.read(b);
            return read;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = Math.min(len, (int)this.buffer.remaining());
        this.buffer.read(b, (long)off, (long)read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = Math.min(n, this.buffer.remaining());
        this.buffer.skip(skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return (int)this.buffer.remaining();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }
}

