/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.map;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.collections.DistributedMap;
import io.atomix.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientConsumer;
import org.apache.camel.component.atomix.client.map.AtomixMapEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomixMapConsumer
extends AbstractAtomixClientConsumer<AtomixMapEndpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(AtomixMapConsumer.class);
    private final List<Listener<DistributedMap.EntryEvent<Object, Object>>> listeners = new ArrayList<Listener<DistributedMap.EntryEvent<Object, Object>>>();
    private final String resourceName;
    private final String resultHeader;
    private DistributedMap<Object, Object> map;

    public AtomixMapConsumer(AtomixMapEndpoint endpoint, Processor processor, String resourceName) {
        super(endpoint, processor);
        this.resourceName = resourceName;
        this.resultHeader = endpoint.getConfiguration().getResultHeader();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.map = (DistributedMap)((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getMap(this.resourceName, new Resource.Config(((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(this.resourceName)), new DistributedMap.Options(((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(this.resourceName))).join();
        Object key = ((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getKey();
        if (key == null) {
            LOG.debug("Subscribe to events for map: {}", (Object)this.resourceName);
            this.listeners.add((Listener<DistributedMap.EntryEvent<Object, Object>>)this.map.onAdd(this::onEvent).join());
            this.listeners.add((Listener<DistributedMap.EntryEvent<Object, Object>>)this.map.onRemove(this::onEvent).join());
            this.listeners.add((Listener<DistributedMap.EntryEvent<Object, Object>>)this.map.onUpdate(this::onEvent).join());
        } else {
            LOG.debug("Subscribe to events for map: {}, key: {}", (Object)this.resourceName, key);
            this.listeners.add((Listener<DistributedMap.EntryEvent<Object, Object>>)this.map.onAdd(key, this::onEvent).join());
            this.listeners.add((Listener<DistributedMap.EntryEvent<Object, Object>>)this.map.onRemove(key, this::onEvent).join());
            this.listeners.add((Listener<DistributedMap.EntryEvent<Object, Object>>)this.map.onUpdate(key, this::onEvent).join());
        }
    }

    protected void doStop() throws Exception {
        this.listeners.forEach(Listener::close);
        super.doStart();
    }

    private void onEvent(DistributedMap.EntryEvent<Object, Object> event) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("CamelAtomixEventType", (Object)event.type());
        exchange.getIn().setHeader("CamelAtomixResourceKey", event.entry().getKey());
        if (this.resultHeader == null) {
            exchange.getIn().setBody(event.entry().getValue());
        } else {
            exchange.getIn().setHeader(this.resultHeader, event.entry().getValue());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }
}

