/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.protocol.OperationRequest;
import java.util.Objects;

public class QueryRequest
extends OperationRequest {
    private long index;
    private Query query;

    public static Builder builder() {
        return new Builder(new QueryRequest());
    }

    public static Builder builder(QueryRequest request) {
        return new Builder(request);
    }

    public long index() {
        return this.index;
    }

    public Query query() {
        return this.query;
    }

    @Override
    public Operation operation() {
        return this.query;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.index = buffer.readLong();
        this.query = (Query)serializer.readObject(buffer);
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeLong(this.index);
        serializer.writeObject((Object)this.query, buffer);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.sequence, this.index, this.query);
    }

    public boolean equals(Object object) {
        if (object instanceof QueryRequest) {
            QueryRequest request = (QueryRequest)object;
            return request.session == this.session && request.sequence == this.sequence && request.query.equals(this.query);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[session=%d, sequence=%d, index=%d, query=%s]", this.getClass().getSimpleName(), this.session, this.sequence, this.index, this.query);
    }

    public static class Builder
    extends OperationRequest.Builder<Builder, QueryRequest> {
        protected Builder(QueryRequest request) {
            super(request);
        }

        public Builder withIndex(long index) {
            ((QueryRequest)this.request).index = (Long)Assert.argNot((Object)index, (index < 0L ? 1 : 0) != 0, (String)"index cannot be less than 0", (Object[])new Object[0]);
            return this;
        }

        public Builder withQuery(Query query) {
            ((QueryRequest)this.request).query = (Query)Assert.notNull((Object)query, (String)"query");
            return this;
        }

        @Override
        public QueryRequest build() {
            super.build();
            Assert.stateNot((((QueryRequest)this.request).index < 0L ? 1 : 0) != 0, (String)"index cannot be less than 0", (Object[])new Object[0]);
            Assert.stateNot((((QueryRequest)this.request).query == null ? 1 : 0) != 0, (String)"query cannot be null", (Object[])new Object[0]);
            return (QueryRequest)this.request;
        }
    }
}

