/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import io.atomix.resource.Resource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.atomix.AtomixAsyncMessageProcessor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientEndpoint;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAtomixClientProducer<E extends AbstractAtomixClientEndpoint, R extends Resource>
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAtomixClientProducer.class);
    private final Map<String, AtomixAsyncMessageProcessor> processors = new HashMap<String, AtomixAsyncMessageProcessor>();
    private ConcurrentMap<String, R> resources = new ConcurrentHashMap<String, R>();

    protected AbstractAtomixClientProducer(E endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
            InvokeOnHeader[] annotations = (InvokeOnHeader[])method.getAnnotationsByType(InvokeOnHeader.class);
            if (annotations == null || annotations.length <= 0) continue;
            for (InvokeOnHeader annotation : annotations) {
                this.bind(annotation, method);
            }
        }
        super.doStart();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getIn();
        String key = this.getProcessorKey(message);
        AtomixAsyncMessageProcessor processor = this.processors.get(key);
        if (processor != null) {
            try {
                return processor.process(message, callback);
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        throw new RuntimeCamelException("No handler for action " + key);
    }

    protected E getAtomixEndpoint() {
        return (E)((Object)((AbstractAtomixClientEndpoint)super.getEndpoint()));
    }

    protected void processResult(Message message, AsyncCallback callback, Object result) {
        if (result != null && !(result instanceof Void)) {
            message.setHeader("CamelAtomixResourceActionHasResult", (Object)true);
            String resultHeader = ((AtomixClientConfiguration)((AbstractAtomixClientEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration()).getResultHeader();
            if (resultHeader != null) {
                message.setHeader(resultHeader, result);
            } else {
                message.setBody(result);
            }
        } else {
            message.setHeader("CamelAtomixResourceActionHasResult", (Object)false);
        }
        callback.done(false);
    }

    protected R getResource(Message message) {
        String resourceName = this.getResourceName(message);
        ObjectHelper.notNull((Object)resourceName, (String)"CamelAtomixResourceName");
        return (R)this.resources.computeIfAbsent(resourceName, name -> this.createResource((String)name));
    }

    protected abstract String getProcessorKey(Message var1);

    protected abstract String getResourceName(Message var1);

    protected abstract R createResource(String var1);

    private void bind(InvokeOnHeader annotation, Method method) {
        if (method.getParameterCount() == 2) {
            if (!Message.class.isAssignableFrom(method.getParameterTypes()[0])) {
                throw new IllegalArgumentException("First argument should be of type Message");
            }
            if (!AsyncCallback.class.isAssignableFrom(method.getParameterTypes()[1])) {
                throw new IllegalArgumentException("Second argument should be of type AsyncCallback");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("bind key={}, class={}, method={}", new Object[]{annotation.value(), ((Object)((Object)this)).getClass(), method.getName()});
            }
        } else {
            throw new IllegalArgumentException("Illegal number of parameters for method: " + method.getName() + ", required: 2, found: " + method.getParameterCount());
        }
        this.processors.put(annotation.value(), (m, c) -> (Boolean)org.apache.camel.support.ObjectHelper.invokeMethodSafe((Method)method, (Object)((Object)this), (Object[])new Object[]{m, c}));
    }
}

