/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotDescriptor;
import io.atomix.copycat.server.storage.snapshot.SnapshotFile;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotStore;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

final class FileSnapshot
extends Snapshot {
    private final SnapshotFile file;
    private final SnapshotStore store;

    FileSnapshot(SnapshotFile file, SnapshotStore store) {
        super(store);
        this.file = (SnapshotFile)Assert.notNull((Object)file, (String)"file");
        this.store = (SnapshotStore)Assert.notNull((Object)store, (String)"store");
    }

    @Override
    public long index() {
        return this.file.index();
    }

    @Override
    public long timestamp() {
        return this.file.timestamp();
    }

    @Override
    public synchronized SnapshotWriter writer() {
        this.checkWriter();
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withIndex(this.file.index()).withTimestamp(this.file.timestamp()).build();
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (long)64L);
        descriptor.copyTo((Buffer)buffer);
        int length = buffer.position(64L).readInt();
        return this.openWriter(new SnapshotWriter(buffer.skip((long)length).mark(), this, this.store.serializer()), descriptor);
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        int length = (int)(writer.buffer.position() - 68L);
        writer.buffer.writeInt(64L, length).flush();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader reader() {
        Assert.state((boolean)this.file.file().exists(), (String)"missing snapshot file: %s", (Object[])new Object[]{this.file.file()});
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (long)64L);
        SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)buffer);
        int length = buffer.position(64L).readInt();
        return this.openReader(new SnapshotReader(buffer.mark().limit((long)(68 + length)), this, this.store.serializer()), descriptor);
    }

    @Override
    public Snapshot complete() {
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (long)64L);
        try (SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)buffer);){
            Assert.stateNot((boolean)descriptor.locked(), (String)"cannot complete locked snapshot descriptor", (Object[])new Object[0]);
            descriptor.lock();
        }
        return super.complete();
    }

    @Override
    public void delete() {
        Path path = this.file.file().toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(this.file.file().toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return String.format("%s[index=%d]", this.getClass().getSimpleName(), this.index());
    }
}

