/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging;

import io.atomix.catalyst.annotations.Experimental;
import io.atomix.catalyst.util.Assert;
import java.util.concurrent.CompletableFuture;

@Experimental
public interface MessageProducer<T>
extends AutoCloseable {
    public <U> CompletableFuture<U> send(T var1);

    @Override
    default public void close() {
    }

    public static class Options {
        private Delivery delivery = Delivery.BROADCAST;
        private Execution execution = Execution.SYNC;

        public Options withDelivery(Delivery delivery) {
            this.delivery = (Delivery)((Object)Assert.notNull((Object)((Object)delivery), (String)"delivery"));
            return this;
        }

        public Delivery getDelivery() {
            return this.delivery;
        }

        public Options withExecution(Execution execution) {
            this.execution = (Execution)((Object)Assert.notNull((Object)((Object)execution), (String)"execution"));
            return this;
        }

        public Execution getExecution() {
            return this.execution;
        }
    }

    public static enum Delivery {
        DIRECT,
        RANDOM,
        BROADCAST;

    }

    public static enum Execution {
        SYNC,
        ASYNC,
        REQUEST_REPLY;

    }
}

