/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.Atomix;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.options.ClientOptions;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AtomixClient
extends Atomix {
    public static Builder builder(String properties) {
        return AtomixClient.builder(PropertiesReader.load((String)properties).properties());
    }

    public static Builder builder(Properties properties) {
        ClientOptions clientProperties = new ClientOptions(properties);
        return AtomixClient.builder().withTransport(clientProperties.transport()).withSerializer(clientProperties.serializer());
    }

    public static Builder builder() {
        return new Builder(ResourceClient.builder());
    }

    private static ResourceClient buildClient(Properties properties) {
        ClientOptions clientProperties = new ClientOptions(properties);
        return ResourceClient.builder().withTransport(clientProperties.transport()).build();
    }

    public AtomixClient(Properties properties) {
        this(AtomixClient.buildClient(properties));
    }

    public AtomixClient(ResourceClient client) {
        super(client);
    }

    public CompletableFuture<Atomix> connect(Address ... cluster) {
        return this.connect(Arrays.asList((Object[])Assert.notNull((Object)cluster, (String)"cluster")));
    }

    public CompletableFuture<Atomix> connect(Collection<Address> cluster) {
        return this.client.connect(cluster).thenApply(v -> this);
    }

    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<AtomixClient> {
        private final ResourceClient.Builder builder;

        private Builder(ResourceClient.Builder builder) {
            this.builder = ((ResourceClient.Builder)Assert.notNull((Object)builder, (String)"builder")).withResourceTypes(Atomix.RESOURCES);
        }

        public Builder withTransport(Transport transport) {
            this.builder.withTransport(transport);
            return this;
        }

        public Builder withConnectionStrategy(ConnectionStrategy connectionStrategy) {
            this.builder.withConnectionStrategy(connectionStrategy);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.builder.withSerializer(serializer);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.builder.withSessionTimeout(sessionTimeout);
            return this;
        }

        public Builder withResourceTypes(Class<? extends Resource<?>> ... types) {
            if (types != null) {
                return this.withResourceTypes(Arrays.asList(types).stream().map(ResourceType::new).collect(Collectors.toList()));
            }
            return this;
        }

        public Builder withResourceTypes(ResourceType ... types) {
            if (types != null) {
                return this.withResourceTypes(Arrays.asList(types));
            }
            return this;
        }

        public Builder withResourceTypes(Collection<ResourceType> types) {
            this.builder.withResourceTypes(types);
            return this;
        }

        public Builder addResourceType(Class<? extends Resource<?>> type) {
            return this.addResourceType(new ResourceType(type));
        }

        public Builder addResourceType(ResourceType type) {
            this.builder.addResourceType(type);
            return this;
        }

        public AtomixClient build() {
            return new AtomixClient(this.builder.build());
        }
    }
}

