/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.group.internal.AsyncMessageState;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.GroupMemberInfo;
import io.atomix.group.internal.MemberState;
import io.atomix.group.internal.MembersState;
import io.atomix.group.internal.QueueState;
import io.atomix.group.internal.RequestReplyMessageState;
import io.atomix.group.internal.SessionState;
import io.atomix.group.internal.SyncMessageState;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class GroupState
extends ResourceStateMachine
implements SessionListener {
    private final Duration expiration;
    private final Map<Long, SessionState> sessions = new HashMap<Long, SessionState>();
    private final MembersState members = new MembersState();
    private final Map<String, QueueState> queues = new HashMap<String, QueueState>();
    private final List<MemberState> candidates = new ArrayList<MemberState>();
    private MemberState leader;
    private long term;

    public GroupState(Properties config) {
        super(config);
        this.expiration = Duration.ofMillis(Long.valueOf(config.getProperty("expiration", "-1")));
    }

    public void unregister(ServerSession session) {
        this.remove(session, true);
    }

    public void expire(ServerSession session) {
        this.remove(session, false);
    }

    public void remove(ServerSession session, boolean force) {
        HashMap<Long, MemberState> left = new HashMap<Long, MemberState>();
        this.sessions.remove(session.id());
        boolean elect = false;
        Iterator<MemberState> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            MemberState member2 = iterator.next();
            if (member2.session() == null || !member2.session().equals(session)) continue;
            if (force || !member2.persistent()) {
                iterator.remove();
                this.candidates.remove(member2);
                left.put(member2.index(), member2);
            } else {
                member2.setSession(null);
                this.candidates.remove(member2);
                if (this.expiration.isZero()) {
                    this.sessions.values().forEach(s -> s.leave(member2));
                } else {
                    this.sessions.values().forEach(s -> s.dead(member2));
                    if (!this.expiration.isNegative()) {
                        this.executor.schedule(this.expiration, () -> {
                            if (member2.session() == null) {
                                this.sessions.values().forEach(s -> s.leave(member2));
                            }
                        });
                    }
                }
            }
            if (this.leader == null || !this.leader.equals(member2)) continue;
            this.resignLeader(false);
            elect = true;
        }
        if (elect) {
            this.incrementTerm();
            this.electLeader();
        }
        left.values().forEach(member -> {
            member.close();
            this.sessions.values().forEach(s -> s.leave((MemberState)member));
        });
    }

    private void incrementTerm() {
        this.term = this.context.index();
        this.sessions.values().forEach(s -> s.term(this.term));
    }

    private void resignLeader(boolean toCandidate) {
        if (this.leader != null) {
            if (toCandidate) {
                this.candidates.add(this.leader);
            }
            this.leader = null;
        }
    }

    private void electLeader() {
        if (this.candidates.isEmpty()) {
            return;
        }
        Random random = new Random(this.term);
        MemberState member = this.candidates.remove(random.nextInt(this.candidates.size()));
        while (member != null) {
            if (!member.session().state().active()) {
                if (this.candidates.isEmpty()) break;
                member = this.candidates.remove(random.nextInt(this.candidates.size()));
                continue;
            }
            this.leader = member;
            this.sessions.values().forEach(s -> s.elect(this.leader));
            break;
        }
    }

    public GroupMemberInfo join(Commit<GroupCommands.Join> commit) {
        try {
            MemberState member = this.members.get(((GroupCommands.Join)commit.operation()).member());
            if (member == null) {
                member = new MemberState(commit);
                this.members.add(member);
                this.candidates.add(member);
                for (SessionState session : this.sessions.values()) {
                    session.join(member);
                }
                if (this.term == 0L) {
                    this.incrementTerm();
                }
                if (this.leader == null) {
                    this.electLeader();
                }
            } else if (member.persistent()) {
                for (SessionState session : this.sessions.values()) {
                    session.join(member);
                }
                member.setSession(commit.session());
                if (this.leader != null && this.leader.equals(member)) {
                    this.resignLeader(true);
                    this.incrementTerm();
                    this.electLeader();
                }
                commit.close();
            } else {
                throw new IllegalArgumentException("cannot recreate ephemeral member");
            }
            return member.info();
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    public void leave(Commit<GroupCommands.Leave> commit) {
        try {
            MemberState member = this.members.remove(((GroupCommands.Leave)commit.operation()).member());
            if (member != null) {
                this.candidates.remove(member);
                if (this.leader != null && this.leader.equals(member)) {
                    this.resignLeader(false);
                    this.incrementTerm();
                    this.electLeader();
                }
                member.close();
                this.sessions.values().forEach(s -> s.leave(member));
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupCommands.GroupStatus listen(Commit<GroupCommands.Listen> commit) {
        try {
            this.sessions.put(commit.session().id(), new SessionState(commit.session()));
            HashSet<GroupMemberInfo> members = new HashSet<GroupMemberInfo>();
            for (MemberState member : this.members) {
                if (member.session() == null || !member.session().state().active()) continue;
                members.add(member.info());
            }
            GroupCommands.GroupStatus groupStatus = new GroupCommands.GroupStatus(this.term, this.leader != null ? this.leader.id() : null, members);
            return groupStatus;
        }
        finally {
            commit.close();
        }
    }

    public void send(Commit<GroupCommands.Message> commit) {
        try {
            QueueState queue = this.queues.computeIfAbsent(((GroupCommands.Message)commit.operation()).queue(), t -> new QueueState(this.members));
            switch (((GroupCommands.Message)commit.operation()).execution()) {
                case SYNC: {
                    queue.submit(new SyncMessageState(commit, queue));
                    break;
                }
                case ASYNC: {
                    queue.submit(new AsyncMessageState(commit, queue));
                    break;
                }
                case REQUEST_REPLY: {
                    queue.submit(new RequestReplyMessageState(commit, queue));
                    break;
                }
                default: {
                    commit.close();
                    throw new IllegalArgumentException("unknown execution policy");
                }
            }
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    public void reply(Commit<GroupCommands.Reply> commit) {
        try {
            QueueState queue = this.queues.get(((GroupCommands.Reply)commit.operation()).queue());
            if (queue != null) {
                queue.reply((GroupCommands.Reply)commit.operation());
            }
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
        this.queues.values().forEach(QueueState::close);
        this.members.close();
    }
}

