/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;

public class GroupMemberInfo
implements CatalystSerializable {
    private long index;
    private String memberId;
    private Object metadata;

    public GroupMemberInfo() {
    }

    public GroupMemberInfo(long index, String memberId, Object metadata) {
        this.index = (Long)Assert.argNot((Object)index, (index <= 0L ? 1 : 0) != 0, (String)"index must be positive", (Object[])new Object[0]);
        this.memberId = (String)Assert.notNull((Object)memberId, (String)"memberId");
        this.metadata = metadata;
    }

    long index() {
        return this.index;
    }

    public String memberId() {
        return this.memberId;
    }

    public Object metadata() {
        return this.metadata;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.index).writeString(this.memberId);
        serializer.writeObject(this.metadata, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.index = buffer.readLong();
        this.memberId = buffer.readString();
        this.metadata = serializer.readObject(buffer);
    }

    public String toString() {
        return String.format("%s[member=%s]", this.getClass().getSimpleName(), this.memberId);
    }
}

