/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.collections.internal.QueueCommands;
import io.atomix.collections.util.DistributedQueueFactory;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

@ResourceTypeInfo(id=-14, factory=DistributedQueueFactory.class)
public class DistributedQueue<T>
extends AbstractResource<DistributedQueue<T>> {
    public DistributedQueue(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.client.submit((Command)new QueueCommands.Add(value));
    }

    public CompletableFuture<Boolean> offer(T value) {
        return this.client.submit((Command)new QueueCommands.Offer(value));
    }

    public CompletableFuture<T> peek() {
        return this.client.submit((Query)new QueueCommands.Peek()).thenApply(v -> v);
    }

    public CompletableFuture<T> poll() {
        return this.client.submit((Command)new QueueCommands.Poll()).thenApply(v -> v);
    }

    public CompletableFuture<T> element() {
        return this.client.submit((Command)new QueueCommands.Element()).thenApply(v -> v);
    }

    public CompletableFuture<T> remove() {
        return this.client.submit((Command)new QueueCommands.Remove()).thenApply(v -> v);
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.client.submit((Command)new QueueCommands.Remove(value)).thenApply(v -> (boolean)((Boolean)v));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.client.submit((Query)new QueueCommands.Contains(value));
    }

    public CompletableFuture<Boolean> contains(Object value, ReadConsistency consistency) {
        return this.client.submit((Query)new QueueCommands.Contains(value, consistency.level()));
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit((Query)new QueueCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.client.submit((Query)new QueueCommands.Size(consistency.level()));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit((Query)new QueueCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.client.submit((Query)new QueueCommands.IsEmpty(consistency.level()));
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit((Command)new QueueCommands.Clear());
    }

    public CompletableFuture<Listener<ValueEvent<T>>> onAdd(Consumer<ValueEvent<T>> callback) {
        return this.onEvent(Events.ADD, callback);
    }

    public CompletableFuture<Listener<ValueEvent<T>>> onRemove(Consumer<ValueEvent<T>> callback) {
        return this.onEvent(Events.REMOVE, callback);
    }

    public static class ValueEvent<T>
    implements Resource.Event,
    CatalystSerializable {
        private Resource.EventType type;
        private T value;

        public ValueEvent() {
        }

        public ValueEvent(Resource.EventType type, T value) {
            this.type = type;
            this.value = value;
        }

        public Resource.EventType type() {
            return this.type;
        }

        public T value() {
            return this.value;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeByte(this.type.id());
            serializer.writeObject(this.value, buffer);
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.type = Events.values()[buffer.readByte()];
            this.value = serializer.readObject(buffer);
        }
    }

    public static enum Events implements Resource.EventType
    {
        ADD,
        REMOVE;


        public int id() {
            return this.ordinal();
        }
    }
}

