/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.collections.internal.MapCommands;
import io.atomix.collections.internal.MapEntry;
import io.atomix.collections.util.DistributedMapFactory;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

@ResourceTypeInfo(id=-11, factory=DistributedMapFactory.class)
public class DistributedMap<K, V>
extends AbstractResource<DistributedMap<K, V>> {
    private final Options options;
    private final Map<K, V> cache;
    private final Map<K, Map<Integer, Set<Consumer>>> eventListeners = new ConcurrentHashMap<K, Map<Integer, Set<Consumer>>>();

    public DistributedMap(CopycatClient client) {
        this(client, (Properties)((Object)new Options()));
    }

    public DistributedMap(CopycatClient client, Properties options) {
        super(client, options);
        this.options = new Options(options);
        this.cache = this.options.isLocalCache() ? new ConcurrentHashMap() : null;
    }

    public Options options() {
        return this.options;
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit((Query)new MapCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.IsEmpty(consistency.level()));
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit((Query)new MapCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.Size(consistency.level()));
    }

    public CompletableFuture<Boolean> containsKey(Object key) {
        return this.client.submit((Query)new MapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsKey(Object key, ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.ContainsKey(key, consistency.level()));
    }

    public CompletableFuture<Boolean> containsValue(Object value) {
        return this.client.submit((Query)new MapCommands.ContainsValue(value));
    }

    public CompletableFuture<Boolean> containsValue(Object value, ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.ContainsValue(value, consistency.level()));
    }

    public CompletableFuture<V> get(Object key) {
        return this.client.submit((Query)new MapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<V> get(Object key, ReadConsistency consistency) {
        if (consistency == ReadConsistency.LOCAL && this.cache != null) {
            return CompletableFuture.completedFuture(this.cache.get(key));
        }
        return this.client.submit((Query)new MapCommands.Get(key, consistency.level())).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue) {
        return this.client.submit((Query)new MapCommands.GetOrDefault(key, defaultValue)).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue, ReadConsistency consistency) {
        if (consistency == ReadConsistency.LOCAL && this.cache != null) {
            return CompletableFuture.completedFuture(this.cache.getOrDefault(key, defaultValue));
        }
        return this.client.submit((Query)new MapCommands.GetOrDefault(key, defaultValue, consistency.level())).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value) {
        return this.client.submit((Command)new MapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value, Duration ttl) {
        return this.client.submit((Command)new MapCommands.Put(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.client.submit((Command)new MapCommands.PutIfAbsent(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value, Duration ttl) {
        return this.client.submit((Command)new MapCommands.PutIfAbsent(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> remove(Object key) {
        return this.client.submit((Command)new MapCommands.Remove(key)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.client.submit((Command)new MapCommands.RemoveIfPresent(key, value));
    }

    public CompletableFuture<V> replace(K key, V value) {
        return this.client.submit((Command)new MapCommands.Replace(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> replace(K key, V value, Duration ttl) {
        return this.client.submit((Command)new MapCommands.Replace(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.client.submit((Command)new MapCommands.ReplaceIfPresent(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue, Duration ttl) {
        return this.client.submit((Command)new MapCommands.ReplaceIfPresent(key, oldValue, newValue, ttl.toMillis()));
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.client.submit((Query)new MapCommands.KeySet()).thenApply(keys -> keys);
    }

    public CompletableFuture<Set<K>> keySet(ReadConsistency consistency) {
        if (consistency == ReadConsistency.LOCAL && this.cache != null) {
            return CompletableFuture.completedFuture(this.cache.keySet());
        }
        return this.client.submit((Query)new MapCommands.KeySet(consistency.level())).thenApply(keys -> keys);
    }

    public CompletableFuture<Collection<V>> values() {
        return this.client.submit((Query)new MapCommands.Values()).thenApply(values -> values);
    }

    public CompletableFuture<Collection<V>> values(ReadConsistency consistency) {
        if (consistency == ReadConsistency.LOCAL && this.cache != null) {
            return CompletableFuture.completedFuture(this.cache.values());
        }
        return this.client.submit((Query)new MapCommands.Values(consistency.level())).thenApply(values -> values);
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.client.submit((Query)new MapCommands.EntrySet()).thenApply(entries -> entries);
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet(ReadConsistency consistency) {
        if (consistency == ReadConsistency.LOCAL && this.cache != null) {
            return CompletableFuture.completedFuture(this.cache.entrySet());
        }
        return this.client.submit((Query)new MapCommands.EntrySet(consistency.level())).thenApply(entries -> entries);
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit((Command)new MapCommands.Clear());
    }

    protected synchronized <T extends Resource.Event> CompletableFuture<Listener<T>> onEvent(final K key, final Resource.EventType type, final Consumer<T> callback) {
        final Map keyListeners = this.eventListeners.computeIfAbsent(key, k -> new ConcurrentHashMap());
        final Set eventListeners = keyListeners.computeIfAbsent(type.id(), id -> new CopyOnWriteArraySet());
        eventListeners.add(callback);
        return ((CompletableFuture)this.client.submit((Command)new MapCommands.KeyListen(type.id(), key)).whenComplete((result, error) -> {
            if (error != null) {
                DistributedMap distributedMap = this;
                synchronized (distributedMap) {
                    eventListeners.remove(callback);
                    if (eventListeners.isEmpty()) {
                        keyListeners.remove(type.id());
                        if (keyListeners.isEmpty()) {
                            this.eventListeners.remove(key);
                        }
                        this.client.submit((Command)new MapCommands.KeyUnlisten(type.id(), key));
                    }
                }
            }
        })).thenApply(v -> new Listener<T>(){

            public void accept(T event) {
                callback.accept(event);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    eventListeners.remove(callback);
                    if (eventListeners.isEmpty()) {
                        keyListeners.remove(type.id());
                        if (keyListeners.isEmpty()) {
                            DistributedMap.this.eventListeners.remove(key);
                        }
                        DistributedMap.this.client.submit((Command)new MapCommands.KeyUnlisten(type.id(), key));
                    }
                }
            }
        });
    }

    public CompletableFuture<Listener<EntryEvent<K, V>>> onAdd(Consumer<EntryEvent<K, V>> callback) {
        return this.onEvent(Events.ADD, callback);
    }

    public CompletableFuture<Listener<EntryEvent<K, V>>> onAdd(K key, Consumer<EntryEvent<K, V>> callback) {
        return this.onEvent(key, Events.ADD, callback);
    }

    public CompletableFuture<Listener<EntryEvent<K, V>>> onUpdate(Consumer<EntryEvent<K, V>> callback) {
        return this.onEvent(Events.UPDATE, callback);
    }

    public CompletableFuture<Listener<EntryEvent<K, V>>> onUpdate(K key, Consumer<EntryEvent<K, V>> callback) {
        return this.onEvent(key, Events.UPDATE, callback);
    }

    public CompletableFuture<Listener<EntryEvent<K, V>>> onRemove(Consumer<EntryEvent<K, V>> callback) {
        return this.onEvent(Events.REMOVE, callback);
    }

    public CompletableFuture<Listener<EntryEvent<K, V>>> onRemove(K key, Consumer<EntryEvent<K, V>> callback) {
        return this.onEvent(key, Events.REMOVE, callback);
    }

    public CompletableFuture<DistributedMap<K, V>> open() {
        CompletionStage future = super.open().thenApply(m -> {
            this.client.onEvent("key", this::onEvent);
            return this;
        });
        if (this.options.isLocalCache()) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)future).thenCompose(v -> this.onAdd(this::onAdd))).thenCompose(v -> this.onUpdate(this::onUpdate))).thenCompose(v -> this.onRemove(this::onRemove))).thenApply(v -> this);
        }
        return future;
    }

    private void onEvent(EntryEvent event) {
        Set<Consumer> eventListeners;
        Map<Integer, Set<Consumer>> keyListeners = this.eventListeners.get(event.entry.getKey());
        if (keyListeners != null && (eventListeners = keyListeners.get(event.type.id())) != null) {
            for (Consumer listener : eventListeners) {
                listener.accept(event);
            }
        }
    }

    private void onAdd(EntryEvent<K, V> event) {
        this.cache.put(((EntryEvent)event).entry.getKey(), ((EntryEvent)event).entry.getValue());
    }

    private void onUpdate(EntryEvent<K, V> event) {
        this.cache.put(((EntryEvent)event).entry.getKey(), ((EntryEvent)event).entry.getValue());
    }

    private void onRemove(EntryEvent<K, V> event) {
        this.cache.remove(((EntryEvent)event).entry.getKey());
    }

    public static class EntryEvent<K, V>
    implements Resource.Event,
    CatalystSerializable {
        private Resource.EventType type;
        private Map.Entry<K, V> entry;

        public EntryEvent() {
        }

        public EntryEvent(Resource.EventType type, Map.Entry<K, V> entry) {
            this.type = type;
            this.entry = entry;
        }

        public Resource.EventType type() {
            return this.type;
        }

        public Map.Entry<K, V> entry() {
            return this.entry;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeByte(this.type.id());
            serializer.writeObject(this.entry.getKey(), buffer);
            serializer.writeObject(this.entry.getValue(), buffer);
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.type = Events.values()[buffer.readByte()];
            Object key = serializer.readObject(buffer);
            Object value = serializer.readObject(buffer);
            this.entry = new MapEntry<Object, Object>(key, value);
        }
    }

    public static enum Events implements Resource.EventType
    {
        ADD,
        UPDATE,
        REMOVE;


        public int id() {
            return this.ordinal();
        }
    }

    public static class Options
    extends Resource.Options {
        public Options() {
        }

        public Options(Properties defaults) {
            super(defaults);
        }

        public Options withLocalCache() {
            return this.withLocalCache(true);
        }

        public Options withLocalCache(boolean enableCache) {
            this.setProperty("cache", String.valueOf(enableCache));
            return this;
        }

        public boolean isLocalCache() {
            return Boolean.parseBoolean(this.getProperty("cache", "false"));
        }
    }
}

