/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.variables.AbstractDistributedValue;
import io.atomix.variables.internal.AbstractValueState;
import io.atomix.variables.internal.LongCommands;
import io.atomix.variables.internal.ValueCommands;
import java.util.Properties;

public class LongState
extends AbstractValueState<Long>
implements Snapshottable {
    private Long value = 0L;

    public LongState(Properties config) {
        super(config);
    }

    public void snapshot(SnapshotWriter writer) {
        writer.writeLong(this.value.longValue());
    }

    public void install(SnapshotReader reader) {
        this.value = reader.readLong();
    }

    @Override
    public void set(Commit<ValueCommands.Set<Long>> commit) {
        try {
            Long oldValue = this.value;
            this.value = (Long)((ValueCommands.Set)commit.operation()).value();
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
        }
        finally {
            commit.close();
        }
    }

    @Override
    public Long get(Commit<ValueCommands.Get<Long>> commit) {
        try {
            Long l = this.value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getAndSet(Commit<ValueCommands.GetAndSet<Long>> commit) {
        try {
            Long oldValue = this.value;
            this.value = (Long)((ValueCommands.GetAndSet)commit.operation()).value();
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            Long l = oldValue;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSet(Commit<ValueCommands.CompareAndSet<Long>> commit) {
        try {
            Long expect = (Long)((ValueCommands.CompareAndSet)commit.operation()).expect();
            if (this.value == null && expect == null || this.value != null && this.value.equals(expect)) {
                Long oldValue = this.value;
                this.value = (Long)((ValueCommands.CompareAndSet)commit.operation()).update();
                this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementAndGet(Commit<LongCommands.IncrementAndGet> commit) {
        try {
            Long oldValue = this.value;
            this.value = oldValue + 1L;
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            long l = this.value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementAndGet(Commit<LongCommands.DecrementAndGet> commit) {
        try {
            Long oldValue = this.value;
            this.value = oldValue - 1L;
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            long l = this.value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndIncrement(Commit<LongCommands.GetAndIncrement> commit) {
        try {
            Long oldValue = this.value;
            this.value = oldValue + 1L;
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            long l = oldValue;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndDecrement(Commit<LongCommands.GetAndDecrement> commit) {
        try {
            Long oldValue = this.value;
            this.value = oldValue - 1L;
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            long l = oldValue;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addAndGet(Commit<LongCommands.AddAndGet> commit) {
        try {
            Long oldValue = this.value;
            this.value = oldValue + ((LongCommands.AddAndGet)commit.operation()).delta();
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            long l = this.value;
            return l;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAndAdd(Commit<LongCommands.GetAndAdd> commit) {
        try {
            Long oldValue = this.value;
            this.value = oldValue + ((LongCommands.GetAndAdd)commit.operation()).delta();
            this.notify(new AbstractDistributedValue.ChangeEvent<Long>(oldValue, this.value));
            long l = oldValue;
            return l;
        }
        finally {
            commit.close();
        }
    }
}

