/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.util;

import java.util.function.Consumer;

public class Quorum {
    private final int quorum;
    private int succeeded = 1;
    private int failed;
    private Consumer<Boolean> callback;
    private boolean complete;

    public Quorum(int quorum, Consumer<Boolean> callback) {
        this.quorum = quorum;
        this.callback = callback;
    }

    private void checkComplete() {
        if (!this.complete && this.callback != null) {
            if (this.succeeded >= this.quorum) {
                this.complete = true;
                this.callback.accept(true);
            } else if (this.failed >= this.quorum) {
                this.complete = true;
                this.callback.accept(false);
            }
        }
    }

    public Quorum succeed() {
        ++this.succeeded;
        this.checkComplete();
        return this;
    }

    public Quorum fail() {
        ++this.failed;
        this.checkComplete();
        return this;
    }

    public void cancel() {
        this.callback = null;
        this.complete = true;
    }
}

