/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.util.reference.ReferenceManager;
import io.atomix.catalyst.util.reference.ReferencePool;
import io.atomix.copycat.server.storage.StorageException;
import io.atomix.copycat.server.storage.entry.Entry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class TypedEntryPool {
    private final Map<Class, ReferencePool<? extends Entry<?>>> pools = new HashMap();

    public <T extends Entry<T>> T acquire(Class<T> type, long index) {
        ReferencePool pool = this.pools.get(type);
        if (pool == null) {
            try {
                Constructor c = type.getConstructor(ReferenceManager.class);
                c.setAccessible(true);
                pool = new ReferencePool(r -> {
                    try {
                        return (Entry)c.newInstance(r);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new StorageException(e);
                    }
                });
            }
            catch (NoSuchMethodException e) {
                throw new SerializationException("failed to instantiate reference: must provide a single argument constructor", (Throwable)e);
            }
            this.pools.put(type, pool);
        }
        Entry entry = (Entry)pool.acquire();
        ((Entry)entry.reset()).setIndex(index);
        return (T)entry;
    }
}

