/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public abstract class AbstractResponse
implements Response {
    protected Response.Status status = Response.Status.OK;
    protected CopycatError error;

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
    }

    @Override
    public Response.Status status() {
        return this.status;
    }

    @Override
    public CopycatError error() {
        return this.error;
    }

    public String toString() {
        return String.format("%s[status=%s, error=%s]", new Object[]{this.getClass().getCanonicalName(), this.status, this.error});
    }

    protected static abstract class Builder<T extends Builder<T, U>, U extends AbstractResponse>
    implements Response.Builder<T, U> {
        protected U response;

        protected Builder(U response) {
            this.response = response;
        }

        @Override
        public T withStatus(Response.Status status) {
            ((AbstractResponse)this.response).status = (Response.Status)((Object)Assert.notNull((Object)((Object)status), (String)"status"));
            return (T)this;
        }

        @Override
        public T withError(CopycatError error) {
            ((AbstractResponse)this.response).error = (CopycatError)Assert.notNull((Object)error, (String)"error");
            return (T)this;
        }

        public U build() {
            Assert.stateNot((((AbstractResponse)this.response).status == null ? 1 : 0) != 0, (String)"status cannot be null", (Object[])new Object[0]);
            return this.response;
        }

        public int hashCode() {
            return Objects.hash(this.response);
        }

        public boolean equals(Object object) {
            return this.getClass().isAssignableFrom(object.getClass()) && ((Builder)object).response.equals(this.response);
        }

        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

