/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.collection;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.util.Assert;
import java.util.Map;

public class MapEntrySerializer
implements TypeSerializer<Map.Entry<?, ?>> {
    @Override
    public void write(Map.Entry<?, ?> object, BufferOutput buffer, Serializer serializer) {
        serializer.writeObject(object.getKey(), buffer);
        serializer.writeObject(object.getValue(), buffer);
    }

    @Override
    public Map.Entry<?, ?> read(Class<Map.Entry<?, ?>> type, BufferInput buffer, Serializer serializer) {
        Object key = serializer.readObject(buffer);
        Object value = serializer.readObject(buffer);
        return new MapEntry(key, value);
    }

    private static class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private MapEntry(K key, V value) {
            this.key = Assert.notNull(key, (String)"key");
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

