/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.map;

import io.atomix.collections.DistributedMap;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import java.time.Duration;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.map.AtomixMapConfiguration;
import org.apache.camel.component.atomix.client.map.AtomixMapEndpoint;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.util.ObjectHelper;

public final class AtomixMapProducer
extends AbstractAtomixClientProducer<AtomixMapEndpoint, DistributedMap<Object, Object>> {
    private final AtomixMapConfiguration configuration;

    protected AtomixMapProducer(AtomixMapEndpoint endpoint) {
        super(endpoint, endpoint.getConfiguration().getDefaultAction().name());
        this.configuration = endpoint.getConfiguration();
    }

    private long getResourceTtl(Message message) {
        Duration ttl = (Duration)message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Duration.class);
        return ttl != null ? ttl.toMillis() : 0L;
    }

    @InvokeOnHeader(value="PUT")
    void onPut(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        long ttl = this.getResourceTtl(message);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            map.put(key, val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.put(key, val).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="PUT_IF_ABSENT")
    void onPutIfAbsent(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        long ttl = this.getResourceTtl(message);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            map.putIfAbsent(key, val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.putIfAbsent(key, val).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="GET")
    void onGet(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        Object defaultValue = message.getHeader("CamelAtomixResourceDefaultValue");
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        if (consistency != null) {
            if (defaultValue != null) {
                map.getOrDefault(key, defaultValue, consistency).thenAccept(result -> this.processResult(message, callback, result));
            } else {
                map.get(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
            }
        } else if (defaultValue != null) {
            map.getOrDefault(key, defaultValue).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.get(key).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CLEAR")
    void onClear(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        map.clear().thenAccept(result -> this.processResult(message, callback, result));
    }

    @InvokeOnHeader(value="SIZE")
    void onSize(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            map.size(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.size().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="IS_EMPTY")
    void onIsEmpty(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            map.isEmpty(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.isEmpty().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="ENTRY_SET")
    void onEntrySet(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            map.entrySet(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.entrySet().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="VALUES")
    void onValues(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            map.values(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.values().thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CONTAINS_KEY")
    void onContainsKey(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object key = message.getHeader("CamelAtomixResourceKey", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        if (consistency != null) {
            map.containsKey(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.containsKey(key).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="CONTAINS_VALUE")
    void onContainsValue(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        if (consistency != null) {
            map.containsValue(value, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.containsValue(value).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="REMOVE")
    void onRemove(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", () -> ((Message)message).getBody(), Object.class);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        if (value != null) {
            map.remove(key, value).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.remove(key).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @InvokeOnHeader(value="REPLACE")
    void onReplace(Message message, AsyncCallback callback) {
        DistributedMap map = (DistributedMap)this.getResource(message);
        long ttl = this.getResourceTtl(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        Object newValue = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        Object oldValue = message.getHeader("CamelAtomixResourceOldValue", Object.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        ObjectHelper.notNull((Object)newValue, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            if (oldValue != null) {
                map.replace(key, oldValue, newValue, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
            } else {
                map.replace(key, newValue, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
            }
        } else if (oldValue != null) {
            map.replace(key, oldValue, newValue).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.replace(key, newValue).thenAccept(result -> this.processResult(message, callback, result));
        }
    }

    @Override
    protected String getResourceName(Message message) {
        return (String)message.getHeader("CamelAtomixResourceName", ((AtomixMapEndpoint)((Object)this.getAtomixEndpoint()))::getResourceName, String.class);
    }

    @Override
    protected DistributedMap<Object, Object> createResource(String resourceName) {
        return (DistributedMap)((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getMap(resourceName, new Resource.Config(((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(resourceName)), new DistributedMap.Options(((AtomixMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

